/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.FileDownloadTaskParam;
import org.wlf.filedownloader.file_download.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.DownloadRecorder;
import org.wlf.filedownloader.file_download.base.DownloadTask;
import org.wlf.filedownloader.file_download.file_saver.FileSaver;
import org.wlf.filedownloader.file_download.http_downloader.ContentLengthInputStream;
import org.wlf.filedownloader.file_download.http_downloader.HttpDownloader;
import org.wlf.filedownloader.file_download.http_downloader.Range;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadTaskImpl
implements DownloadTask,
HttpDownloader.OnHttpDownloadListener,
FileSaver.OnFileSaveListener,
HttpDownloader.OnRangeChangeListener {
    private static final String TAG = DownloadTaskImpl.class.getSimpleName();
    private FileDownloadTaskParam mTaskParamInfo;
    private HttpDownloader mDownloader;
    private FileSaver mSaver;
    private DownloadRecorder mDownloadRecorder;
    private OnFileDownloadStatusListener mOnFileDownloadStatusListener;
    private OnStopFileDownloadTaskListener mOnStopFileDownloadTaskListener;
    private FinishState mFinishState;
    private boolean mIsTaskStop = false;
    private boolean mIsRunning = false;
    private long mLastDownloadingTime = -1L;
    private boolean mIsNotifyTaskFinish;
    private Thread mCurrentTaskThread;
    private ExecutorService mCloseConnectionEngine;
    private int mConnectTimeout = 15000;

    public DownloadTaskImpl(FileDownloadTaskParam taskParamInfo, DownloadRecorder downloadRecorder, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mTaskParamInfo = taskParamInfo;
        this.init();
        this.mDownloadRecorder = downloadRecorder;
        this.mOnFileDownloadStatusListener = onFileDownloadStatusListener;
        if (!this.checkTaskCanExecute()) {
            this.stop();
            this.notifyTaskFinish();
            return;
        }
        if (!this.notifyStatusWaiting()) {
            this.stop();
            this.notifyTaskFinish();
            return;
        }
        if (this.mSaver == null || this.mSaver.isStopped()) {
            this.stop();
            this.notifyTaskFinish();
            return;
        }
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            this.notifyTaskFinish();
        }
    }

    private void init() {
        Log.d(TAG, TAG + ".init 1\u3001\u521d\u59cb\u5316\u65b0\u4e0b\u8f7d\u4efb\u52a1\uff0curl\uff1a" + this.mTaskParamInfo.url);
        Range range = new Range(this.mTaskParamInfo.startPosInTotal, this.mTaskParamInfo.fileTotalSize);
        this.mDownloader = new HttpDownloader(this.mTaskParamInfo.url, range, this.mTaskParamInfo.acceptRangeType, this.mTaskParamInfo.eTag, this.mTaskParamInfo.lastModified);
        this.mDownloader.setOnHttpDownloadListener(this);
        this.mDownloader.setCloseConnectionEngine(this.mCloseConnectionEngine);
        this.mDownloader.setConnectTimeout(this.mConnectTimeout);
        this.mDownloader.setOnRangeChangeListener(this);
        this.mSaver = new FileSaver(this.mTaskParamInfo.url, this.mTaskParamInfo.tempFilePath, this.mTaskParamInfo.filePath, this.mTaskParamInfo.fileTotalSize);
        this.mSaver.setOnFileSaveListener(this);
    }

    private boolean checkTaskCanExecute() {
        DownloadFileInfo downloadFileInfo;
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (this.mTaskParamInfo == null) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "init param is null pointer !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
        }
        if (failReason == null && !UrlUtil.isUrl(this.mTaskParamInfo.url)) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "url illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_URL_ILLEGAL);
        }
        if (failReason == null && !FileUtil.isFilePath(this.mTaskParamInfo.filePath)) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "saveDir illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_SAVE_PATH_ILLEGAL);
        }
        if (!(failReason != null || FileUtil.canWrite(this.mTaskParamInfo.tempFilePath) && FileUtil.canWrite(this.mTaskParamInfo.filePath))) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "savePath can not write !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_STORAGE_SPACE_CAN_NOT_WRITE);
        }
        if (failReason == null && (downloadFileInfo = this.getDownloadFile()) != null) {
            boolean isSucceed;
            if (downloadFileInfo.getStatus() == 5) {
                this.mFinishState = new FinishState(5);
                return false;
            }
            if (downloadFileInfo.getDownloadedSizeLong() == downloadFileInfo.getFileSizeLong() && (isSucceed = DownloadFileUtil.tryToRenameTempFileToSaveFile(downloadFileInfo))) {
                this.mFinishState = new FinishState(5);
                return false;
            }
        }
        if (failReason == null) {
            try {
                String checkPath = null;
                File file = new File(this.mTaskParamInfo.filePath);
                if (file != null) {
                    checkPath = file.getParentFile().getAbsolutePath();
                }
                if (!FileUtil.isFilePath(checkPath)) {
                    failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "file save path illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_SAVE_PATH_ILLEGAL);
                } else {
                    long freeSize = FileUtil.getAvailableSpace(checkPath);
                    long needDownloadSize = this.mTaskParamInfo.fileTotalSize - this.mTaskParamInfo.startPosInTotal;
                    if (freeSize == -1L || needDownloadSize > freeSize) {
                        failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "storage space is full or storage can not write !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_STORAGE_SPACE_IS_FULL);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e);
            }
        }
        if (failReason != null) {
            this.mFinishState = new FinishState(7, failReason);
            return false;
        }
        return true;
    }

    @Override
    public void setOnStopFileDownloadTaskListener(OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.mOnStopFileDownloadTaskListener = onStopFileDownloadTaskListener;
    }

    public void setCloseConnectionEngine(ExecutorService closeConnectionEngine) {
        this.mCloseConnectionEngine = closeConnectionEngine;
        if (this.mDownloader != null) {
            this.mDownloader.setCloseConnectionEngine(this.mCloseConnectionEngine);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        if (this.mDownloader != null) {
            this.mDownloader.setConnectTimeout(this.mConnectTimeout);
        }
    }

    private DownloadFileInfo getDownloadFile() {
        if (this.mDownloadRecorder == null) {
            return null;
        }
        return this.mDownloadRecorder.getDownloadFile(this.mTaskParamInfo.url);
    }

    @Override
    public String getUrl() {
        if (this.mTaskParamInfo == null) {
            return null;
        }
        return this.mTaskParamInfo.url;
    }

    public FinishState getFinishState() {
        return this.mFinishState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block95: {
            long fileSize;
            DownloadFileInfo downloadFileInfo;
            block94: {
                block91: {
                    block93: {
                        long fileSize2;
                        DownloadFileInfo downloadFileInfo2;
                        block92: {
                            block88: {
                                block90: {
                                    long fileSize3;
                                    DownloadFileInfo downloadFileInfo3;
                                    block89: {
                                        block85: {
                                            block87: {
                                                long fileSize4;
                                                DownloadFileInfo downloadFileInfo4;
                                                block86: {
                                                    block82: {
                                                        block84: {
                                                            long fileSize5;
                                                            DownloadFileInfo downloadFileInfo5;
                                                            block83: {
                                                                this.mIsRunning = true;
                                                                this.mCurrentTaskThread = Thread.currentThread();
                                                                if (!this.mIsTaskStop) break block82;
                                                                this.stopInternalImpl();
                                                                downloadFileInfo5 = this.getDownloadFile();
                                                                if (downloadFileInfo5 != null) break block83;
                                                                OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                                                                this.mFinishState = new FinishState(7, failReason);
                                                                break block84;
                                                            }
                                                            long downloadedSize = downloadFileInfo5.getDownloadedSizeLong();
                                                            if (downloadedSize == (fileSize5 = downloadFileInfo5.getFileSizeLong())) {
                                                                if (this.mFinishState != null) {
                                                                    if (this.mFinishState.status != 5) {
                                                                        this.mFinishState = new FinishState(5);
                                                                    }
                                                                } else {
                                                                    this.mFinishState = new FinishState(5);
                                                                }
                                                            } else if (downloadedSize < fileSize5) {
                                                                if (this.mFinishState != null) {
                                                                    if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                                                        this.mFinishState = new FinishState(6);
                                                                    }
                                                                } else {
                                                                    this.mFinishState = new FinishState(6);
                                                                }
                                                            } else {
                                                                OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                                                                this.mFinishState = new FinishState(7, failReason);
                                                            }
                                                        }
                                                        this.mIsTaskStop = true;
                                                        this.mIsRunning = false;
                                                        this.stopInternalImpl();
                                                        this.notifyTaskFinish();
                                                        this.notifyStopTaskSucceedIfNecessary();
                                                        boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                                                        Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                                                        return;
                                                    }
                                                    if (this.mSaver == null || this.mSaver.isStopped()) {
                                                        this.init();
                                                    }
                                                    if (this.mSaver != null && !this.mSaver.isStopped()) break block85;
                                                    this.stopInternalImpl();
                                                    downloadFileInfo4 = this.getDownloadFile();
                                                    if (downloadFileInfo4 != null) break block86;
                                                    OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                                                    this.mFinishState = new FinishState(7, failReason);
                                                    break block87;
                                                }
                                                long downloadedSize = downloadFileInfo4.getDownloadedSizeLong();
                                                if (downloadedSize == (fileSize4 = downloadFileInfo4.getFileSizeLong())) {
                                                    if (this.mFinishState != null) {
                                                        if (this.mFinishState.status != 5) {
                                                            this.mFinishState = new FinishState(5);
                                                        }
                                                    } else {
                                                        this.mFinishState = new FinishState(5);
                                                    }
                                                } else if (downloadedSize < fileSize4) {
                                                    if (this.mFinishState != null) {
                                                        if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                                            this.mFinishState = new FinishState(6);
                                                        }
                                                    } else {
                                                        this.mFinishState = new FinishState(6);
                                                    }
                                                } else {
                                                    OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                                                    this.mFinishState = new FinishState(7, failReason);
                                                }
                                            }
                                            this.mIsTaskStop = true;
                                            this.mIsRunning = false;
                                            this.stopInternalImpl();
                                            this.notifyTaskFinish();
                                            this.notifyStopTaskSucceedIfNecessary();
                                            boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                                            Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                                            return;
                                        }
                                        Log.d(TAG, TAG + ".run 2\u3001\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u6b63\u5728\u83b7\u53d6\u8d44\u6e90\uff0curl\uff1a\uff1a" + this.mTaskParamInfo.url);
                                        if (UrlUtil.isUrl(this.mTaskParamInfo.url)) break block88;
                                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "url illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_URL_ILLEGAL);
                                        this.mFinishState = new FinishState(7, failReason);
                                        downloadFileInfo3 = this.getDownloadFile();
                                        if (downloadFileInfo3 != null) break block89;
                                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason2 = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                                        this.mFinishState = new FinishState(7, failReason2);
                                        break block90;
                                    }
                                    long downloadedSize = downloadFileInfo3.getDownloadedSizeLong();
                                    if (downloadedSize == (fileSize3 = downloadFileInfo3.getFileSizeLong())) {
                                        if (this.mFinishState != null) {
                                            if (this.mFinishState.status != 5) {
                                                this.mFinishState = new FinishState(5);
                                            }
                                        } else {
                                            this.mFinishState = new FinishState(5);
                                        }
                                    } else if (downloadedSize < fileSize3) {
                                        if (this.mFinishState != null) {
                                            if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                                this.mFinishState = new FinishState(6);
                                            }
                                        } else {
                                            this.mFinishState = new FinishState(6);
                                        }
                                    } else {
                                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                                        this.mFinishState = new FinishState(7, failReason);
                                    }
                                }
                                this.mIsTaskStop = true;
                                this.mIsRunning = false;
                                this.stopInternalImpl();
                                this.notifyTaskFinish();
                                this.notifyStopTaskSucceedIfNecessary();
                                boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                                Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                                return;
                            }
                            if (this.notifyStatusPreparing()) break block91;
                            this.stopInternalImpl();
                            downloadFileInfo2 = this.getDownloadFile();
                            if (downloadFileInfo2 != null) break block92;
                            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                            this.mFinishState = new FinishState(7, failReason);
                            break block93;
                        }
                        long downloadedSize = downloadFileInfo2.getDownloadedSizeLong();
                        if (downloadedSize == (fileSize2 = downloadFileInfo2.getFileSizeLong())) {
                            if (this.mFinishState != null) {
                                if (this.mFinishState.status != 5) {
                                    this.mFinishState = new FinishState(5);
                                }
                            } else {
                                this.mFinishState = new FinishState(5);
                            }
                        } else if (downloadedSize < fileSize2) {
                            if (this.mFinishState != null) {
                                if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                    this.mFinishState = new FinishState(6);
                                }
                            } else {
                                this.mFinishState = new FinishState(6);
                            }
                        } else {
                            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                            this.mFinishState = new FinishState(7, failReason);
                        }
                    }
                    this.mIsTaskStop = true;
                    this.mIsRunning = false;
                    this.stopInternalImpl();
                    this.notifyTaskFinish();
                    this.notifyStopTaskSucceedIfNecessary();
                    boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                    Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                    return;
                }
                try {
                    this.mFinishState = null;
                    this.mDownloader.download();
                    downloadFileInfo = this.getDownloadFile();
                    if (downloadFileInfo != null) break block94;
                    OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                    this.mFinishState = new FinishState(7, failReason);
                    break block95;
                }
                catch (Exception e) {
                    long fileSize6;
                    DownloadFileInfo downloadFileInfo6;
                    block96: {
                        try {
                            FileSaver.FileSaveException fileSaveException;
                            e.printStackTrace();
                            int status = 7;
                            if (e instanceof FileSaver.FileSaveException && FileSaver.FileSaveException.TYPE_TEMP_FILE_DOES_NOT_EXIST.equals((fileSaveException = (FileSaver.FileSaveException)e).getType())) {
                                status = 8;
                            }
                            this.mFinishState = new FinishState(status, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
                            downloadFileInfo6 = this.getDownloadFile();
                            if (downloadFileInfo6 != null) break block96;
                            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                            this.mFinishState = new FinishState(7, failReason);
                        }
                        catch (Throwable throwable) {
                            DownloadFileInfo downloadFileInfo7 = this.getDownloadFile();
                            if (downloadFileInfo7 == null) {
                                OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null, may be not deleted ?", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                                this.mFinishState = new FinishState(7, failReason);
                            } else {
                                long fileSize7;
                                long downloadedSize = downloadFileInfo7.getDownloadedSizeLong();
                                if (downloadedSize == (fileSize7 = downloadFileInfo7.getFileSizeLong())) {
                                    if (this.mFinishState != null) {
                                        if (this.mFinishState.status != 5) {
                                            this.mFinishState = new FinishState(5);
                                        }
                                    } else {
                                        this.mFinishState = new FinishState(5);
                                    }
                                } else if (downloadedSize < fileSize7) {
                                    if (this.mFinishState != null) {
                                        if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                            this.mFinishState = new FinishState(6);
                                        }
                                    } else {
                                        this.mFinishState = new FinishState(6);
                                    }
                                } else {
                                    OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                                    this.mFinishState = new FinishState(7, failReason);
                                }
                            }
                            this.mIsTaskStop = true;
                            this.mIsRunning = false;
                            this.stopInternalImpl();
                            this.notifyTaskFinish();
                            this.notifyStopTaskSucceedIfNecessary();
                            boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                            Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                            throw throwable;
                        }
                    }
                    long downloadedSize = downloadFileInfo6.getDownloadedSizeLong();
                    if (downloadedSize == (fileSize6 = downloadFileInfo6.getFileSizeLong())) {
                        if (this.mFinishState != null) {
                            if (this.mFinishState.status != 5) {
                                this.mFinishState = new FinishState(5);
                            }
                        } else {
                            this.mFinishState = new FinishState(5);
                        }
                    } else if (downloadedSize < fileSize6) {
                        if (this.mFinishState != null) {
                            if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                                this.mFinishState = new FinishState(6);
                            }
                        } else {
                            this.mFinishState = new FinishState(6);
                        }
                    } else {
                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                        this.mFinishState = new FinishState(7, failReason);
                    }
                    this.mIsTaskStop = true;
                    this.mIsRunning = false;
                    this.stopInternalImpl();
                    this.notifyTaskFinish();
                    this.notifyStopTaskSucceedIfNecessary();
                    boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
                    Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
                }
            }
            long downloadedSize = downloadFileInfo.getDownloadedSizeLong();
            if (downloadedSize == (fileSize = downloadFileInfo.getFileSizeLong())) {
                if (this.mFinishState != null) {
                    if (this.mFinishState.status != 5) {
                        this.mFinishState = new FinishState(5);
                    }
                } else {
                    this.mFinishState = new FinishState(5);
                }
            } else if (downloadedSize < fileSize) {
                if (this.mFinishState != null) {
                    if (this.mFinishState.failReason == null && !DownloadFileUtil.hasException(this.mFinishState.status)) {
                        this.mFinishState = new FinishState(6);
                    }
                } else {
                    this.mFinishState = new FinishState(6);
                }
            } else {
                OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the download file size error !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                this.mFinishState = new FinishState(7, failReason);
            }
        }
        this.mIsTaskStop = true;
        this.mIsRunning = false;
        this.stopInternalImpl();
        this.notifyTaskFinish();
        this.notifyStopTaskSucceedIfNecessary();
        boolean hasException = this.mFinishState != null && this.mFinishState.failReason != null && DownloadFileUtil.hasException(this.mFinishState.status);
        Log.d(TAG, TAG + ".run 7\u3001\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + this.mTaskParamInfo.url);
    }

    @Override
    public boolean onRangeChanged(Range oldRange, Range newRange) {
        if (Range.isLegal(newRange)) {
            if (newRange.startPos > oldRange.startPos && oldRange.startPos >= 0L) {
                return false;
            }
            try {
                this.mDownloadRecorder.resetDownloadSize(this.mTaskParamInfo.url, newRange.startPos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void onDownloadConnected(ContentLengthInputStream inputStream, long startPosInTotal) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        Log.d(TAG, TAG + ".run 3\u3001\u5df2\u7ecf\u8fde\u63a5\u5230\u8d44\u6e90\uff0curl\uff1a" + this.mTaskParamInfo.url);
        if (!this.notifyStatusPrepared()) {
            this.stopInternalImpl();
            return;
        }
        try {
            this.mSaver.saveData(inputStream, startPosInTotal);
        }
        catch (FileSaver.FileSaveException e) {
            e.printStackTrace();
            this.mFinishState = new FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
        }
    }

    @Override
    public void onSaveDataStart() {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        Log.d(TAG, TAG + ".run 4\u3001\u51c6\u5907\u4e0b\u8f7d\uff0curl\uff1a" + this.mTaskParamInfo.url);
        if (!this.notifyStatusDownloading(0)) {
            this.stopInternalImpl();
            return;
        }
    }

    @Override
    public void onSavingData(int increaseSize, long totalSize) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        Log.d(TAG, TAG + ".run 5\u3001\u4e0b\u8f7d\u4e2d\uff0curl\uff1a" + this.mTaskParamInfo.url);
        if (!this.notifyStatusDownloading(increaseSize)) {
            this.stopInternalImpl();
            return;
        }
    }

    @Override
    public void onSaveDataEnd(int increaseSize, boolean complete) {
        if (!complete) {
            this.mFinishState = new FinishState(6, increaseSize);
            Log.d(TAG, TAG + ".run 6\u3001\u6682\u505c\u4e0b\u8f7d\uff0curl\uff1a" + this.mTaskParamInfo.url);
        } else {
            this.mFinishState = new FinishState(5, increaseSize);
            Log.d(TAG, TAG + ".run 6\u3001\u4e0b\u8f7d\u5b8c\u6210\uff0curl\uff1a" + this.mTaskParamInfo.url);
        }
    }

    private boolean notifyStatusWaiting() {
        try {
            this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 1, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                this.mOnFileDownloadStatusListener.onFileDownloadStatusWaiting(this.getDownloadFile());
            }
            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u7b49\u5f85\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mFinishState = new FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
            return false;
        }
    }

    private boolean notifyStatusPreparing() {
        try {
            this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 2, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                this.mOnFileDownloadStatusListener.onFileDownloadStatusPreparing(this.getDownloadFile());
            }
            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6b63\u5728\u51c6\u5907\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mFinishState = new FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
            return false;
        }
    }

    private boolean notifyStatusPrepared() {
        try {
            this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 3, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                this.mOnFileDownloadStatusListener.onFileDownloadStatusPrepared(this.getDownloadFile());
            }
            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u5df2\u51c6\u5907\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mFinishState = new FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
            return false;
        }
    }

    private boolean notifyStatusDownloading(int increaseSize) {
        try {
            this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 4, increaseSize);
            DownloadFileInfo downloadFileInfo = this.getDownloadFile();
            if (downloadFileInfo == null) {
                increaseSize = 0;
                OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, "the DownloadFile is null!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                this.mFinishState = new FinishState(7, increaseSize, failReason);
                return false;
            }
            if (this.mOnFileDownloadStatusListener != null) {
                long remainingSize;
                double downloadSpeed = 0.0;
                long remainingTime = -1L;
                long curDownloadingTime = SystemClock.elapsedRealtime();
                if (this.mLastDownloadingTime != -1L) {
                    double increaseKbs = (double)increaseSize / 1024.0;
                    double increaseSeconds = (double)(curDownloadingTime - this.mLastDownloadingTime) / 1000.0;
                    downloadSpeed = increaseKbs / increaseSeconds;
                }
                if (downloadSpeed > 0.0 && (remainingSize = downloadFileInfo.getFileSizeLong() - downloadFileInfo.getDownloadedSizeLong()) > 0L) {
                    remainingTime = (long)((double)remainingSize / 1024.0 / downloadSpeed);
                }
                this.mLastDownloadingTime = curDownloadingTime;
                if (this.mOnFileDownloadStatusListener != null) {
                    this.mOnFileDownloadStatusListener.onFileDownloadStatusDownloading(downloadFileInfo, (float)downloadSpeed, remainingTime);
                }
            }
            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6b63\u5728\u4e0b\u8f7d\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            increaseSize = 0;
            this.mFinishState = new FinishState(7, increaseSize, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void notifyTaskFinish() {
        if (this.mFinishState == null) {
            this.mFinishState = new FinishState(6);
        }
        int status = this.mFinishState.status;
        int increaseSize = this.mFinishState.increaseSize;
        OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason = this.mFinishState.failReason;
        switch (status) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.mIsNotifyTaskFinish) {
                    return;
                }
                this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, status, increaseSize);
                switch (status) {
                    case 6: {
                        if (this.mOnFileDownloadStatusListener != null) {
                            this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                        }
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                        this.mIsNotifyTaskFinish = true;
                        break;
                    }
                    case 5: {
                        if (this.mOnFileDownloadStatusListener != null) {
                            this.mOnFileDownloadStatusListener.onFileDownloadStatusCompleted(this.getDownloadFile());
                        }
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u5b8c\u6210\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                        this.mIsNotifyTaskFinish = true;
                        break;
                    }
                    case 7: {
                        if (this.mOnFileDownloadStatusListener != null) {
                            this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), failReason);
                        }
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u9519\u8bef\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                        this.mIsNotifyTaskFinish = true;
                        break;
                    }
                    case 8: {
                        if (this.mOnFileDownloadStatusListener != null) {
                            this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), failReason);
                        }
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6587\u4ef6\u4e0d\u5b58\u5728\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                        this.mIsNotifyTaskFinish = true;
                    }
                }
                if (this.mIsNotifyTaskFinish) break;
                try {
                    this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 6, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.mOnFileDownloadStatusListener != null) {
                    this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                }
                Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                this.mIsNotifyTaskFinish = true;
                break;
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        try {
                            this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 7, 0);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (this.mOnFileDownloadStatusListener != null) {
                            this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.mTaskParamInfo.url, e));
                        }
                        Log.e(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c/\u5b8c\u6210/\u51fa\u9519\u72b6\u6001\u3011\u5931\u8d25\uff0curl\uff1a" + this.mTaskParamInfo.url);
                        this.mIsNotifyTaskFinish = true;
                        if (this.mIsNotifyTaskFinish) break;
                    }
                    catch (Throwable throwable) {
                        if (!this.mIsNotifyTaskFinish) {
                            try {
                                this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 6, 0);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            if (this.mOnFileDownloadStatusListener != null) {
                                this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                            }
                            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                            this.mIsNotifyTaskFinish = true;
                        }
                        throw throwable;
                    }
                    try {
                        this.mDownloadRecorder.recordStatus(this.mTaskParamInfo.url, 6, 0);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                    if (this.mOnFileDownloadStatusListener != null) {
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                    }
                    Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
                    this.mIsNotifyTaskFinish = true;
                    break;
                }
            }
        }
    }

    private void notifyStopTaskSucceedIfNecessary() {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(this.mTaskParamInfo.url);
            this.mOnStopFileDownloadTaskListener = null;
            Log.i(TAG, "file-downloader-status \u901a\u77e5\u3010\u6682\u505c\u4efb\u52a1\u3011\u6210\u529f\uff0curl\uff1a" + this.mTaskParamInfo.url);
        }
    }

    private void notifyStopTaskFailedIfNecessary(OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(this.mTaskParamInfo.url, failReason);
            this.mOnStopFileDownloadTaskListener = null;
            Log.e(TAG, "file-downloader-status \u901a\u77e5\u3010\u6682\u505c\u4efb\u52a1\u3011\u5931\u8d25\uff0curl\uff1a" + this.mTaskParamInfo.url);
        }
    }

    @Override
    public boolean isStopped() {
        if (this.mIsTaskStop && !this.mSaver.isStopped()) {
            this.stopInternalImpl();
        }
        return this.mIsTaskStop;
    }

    @Override
    public void stop() {
        Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c\uff0curl\uff1a" + this.mTaskParamInfo.url + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + this.mIsTaskStop);
        if (this.isStopped()) {
            this.notifyStopTaskFailedIfNecessary(new OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason(this.mTaskParamInfo.url, "the task has been stopped!", OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED));
            return;
        }
        if (Thread.currentThread() == this.mCurrentTaskThread) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    DownloadTaskImpl.this.mIsTaskStop = true;
                    Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c(\u4e3b\u7ebf\u7a0b\u53d1\u8d77)\uff0curl\uff1a" + ((DownloadTaskImpl)DownloadTaskImpl.this).mTaskParamInfo.url + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + DownloadTaskImpl.this.mIsTaskStop);
                    DownloadTaskImpl.this.stopInternalImpl();
                }
            });
        } else {
            this.mIsTaskStop = true;
            Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c(\u5176\u5b83\u7ebf\u7a0b\u53d1\u8d77)\uff0curl\uff1a" + this.mTaskParamInfo.url + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + this.mIsTaskStop);
            this.stopInternalImpl();
        }
    }

    private void stopInternalImpl() {
        if (Thread.currentThread() == this.mCurrentTaskThread) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (!DownloadTaskImpl.this.mSaver.isStopped()) {
                        DownloadTaskImpl.this.mSaver.stop();
                    }
                    if (!DownloadTaskImpl.this.mIsRunning) {
                        DownloadTaskImpl.this.notifyTaskFinish();
                        DownloadTaskImpl.this.notifyStopTaskSucceedIfNecessary();
                    }
                }
            });
        } else {
            if (!this.mSaver.isStopped()) {
                this.mSaver.stop();
            }
            if (!this.mIsRunning) {
                this.notifyTaskFinish();
                this.notifyStopTaskSucceedIfNecessary();
            }
        }
    }

    static class FinishState {
        public final int status;
        public final int increaseSize;
        public final OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason;

        public FinishState(int status) {
            this.status = status;
            this.increaseSize = 0;
            this.failReason = null;
        }

        public FinishState(int status, int increaseSize) {
            this.status = status;
            this.increaseSize = increaseSize;
            this.failReason = null;
        }

        public FinishState(int status, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason) {
            this.status = status;
            this.increaseSize = 0;
            this.failReason = failReason;
        }

        public FinishState(int status, int increaseSize, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason) {
            this.status = status;
            this.increaseSize = increaseSize;
            this.failReason = failReason;
        }

        public int getStatus() {
            return this.status;
        }

        public int getIncreaseSize() {
            return this.increaseSize;
        }

        public OnFileDownloadStatusListener.FileDownloadStatusFailReason getFailReason() {
            return this.failReason;
        }
    }
}

