/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.text.TextUtils;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.wlf.filedownloader.file_download.DetectUrlFileInfo;
import org.wlf.filedownloader.util.DateUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.UrlUtil;

class DetectUrlFileCacher {
    private Map<String, DetectUrlFileInfo> mDetectUrlFileInfoMap = new HashMap<String, DetectUrlFileInfo>();
    private Object mModifyLock = new Object();

    DetectUrlFileCacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrUpdateDetectUrlFile(DetectUrlFileInfo detectUrlFileInfo) {
        if (detectUrlFileInfo == null) {
            return false;
        }
        String url = detectUrlFileInfo.getUrl();
        if (!UrlUtil.isUrl(url)) {
            return false;
        }
        DetectUrlFileInfo urlFileInfo = this.mDetectUrlFileInfoMap.get(url);
        Object object = this.mModifyLock;
        synchronized (object) {
            if (urlFileInfo != null) {
                urlFileInfo.update(detectUrlFileInfo);
                return true;
            }
            this.mDetectUrlFileInfoMap.put(url, detectUrlFileInfo);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDetectUrlFile(String url) {
        Object object = this.mModifyLock;
        synchronized (object) {
            this.mDetectUrlFileInfoMap.remove(url);
        }
    }

    public DetectUrlFileInfo getDetectUrlFile(String url) {
        DetectUrlFileInfo detectUrlFileInfo = this.mDetectUrlFileInfoMap.get(url);
        if (DownloadFileUtil.isLegal(detectUrlFileInfo)) {
            Date createDate;
            String createDatetime = detectUrlFileInfo.getCreateDatetime();
            if (!TextUtils.isEmpty((CharSequence)detectUrlFileInfo.getCreateDatetime()) && (createDate = DateUtil.string2Date_yyyy_MM_dd_HH_mm_ss(createDatetime)) != null) {
                GregorianCalendar createDateCalendar = new GregorianCalendar();
                createDateCalendar.setTime(createDate);
                GregorianCalendar curDateCalendar = new GregorianCalendar();
                curDateCalendar.setTime(new Date());
                createDateCalendar.add(6, 1);
                if (curDateCalendar.after(createDateCalendar)) {
                    this.removeDetectUrlFile(detectUrlFileInfo.getUrl());
                    detectUrlFileInfo = null;
                }
            }
        }
        return detectUrlFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mModifyLock;
        synchronized (object) {
            this.mDetectUrlFileInfoMap.clear();
        }
    }
}

