/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;

public interface OnMoveDownloadFileListener {
    public void onMoveDownloadFilePrepared(DownloadFileInfo var1);

    public void onMoveDownloadFileSuccess(DownloadFileInfo var1);

    public void onMoveDownloadFileFailed(DownloadFileInfo var1, MoveDownloadFileFailReason var2);

    public static class MoveDownloadFileFailReason
    extends FailReason {
        public static final String TYPE_TARGET_FILE_EXIST = MoveDownloadFileFailReason.class.getName() + "_TYPE_TARGET_FILE_EXIST";
        public static final String TYPE_ORIGINAL_FILE_NOT_EXIST = MoveDownloadFileFailReason.class.getName() + "_TYPE_ORIGINAL_FILE_NOT_EXIST";
        public static final String TYPE_UPDATE_RECORD_ERROR = MoveDownloadFileFailReason.class.getName() + "_TYPE_UPDATE_RECORD_ERROR";
        public static final String TYPE_FILE_STATUS_ERROR = MoveDownloadFileFailReason.class.getName() + "_TYPE_FILE_STATUS_ERROR";

        public MoveDownloadFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public MoveDownloadFileFailReason(Throwable throwable) {
            super(throwable);
        }
    }

    @Deprecated
    public static class OnMoveDownloadFileFailReason
    extends MoveDownloadFileFailReason {
        public OnMoveDownloadFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnMoveDownloadFileFailReason(Throwable throwable) {
            super(throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onMoveDownloadFilePrepared(final DownloadFileInfo downloadFileNeedToMove, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onMoveDownloadFileListener == null) {
                        return;
                    }
                    onMoveDownloadFileListener.onMoveDownloadFilePrepared(downloadFileNeedToMove);
                }
            });
        }

        public static void onMoveDownloadFileSuccess(final DownloadFileInfo downloadFileMoved, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onMoveDownloadFileListener == null) {
                        return;
                    }
                    onMoveDownloadFileListener.onMoveDownloadFileSuccess(downloadFileMoved);
                }
            });
        }

        public static void onMoveDownloadFileFailed(final DownloadFileInfo downloadFileInfo, final MoveDownloadFileFailReason failReason, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onMoveDownloadFileListener == null) {
                        return;
                    }
                    onMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, failReason);
                }
            });
        }
    }
}

