/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download.file_saver;

import android.os.SystemClock;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.wlf.filedownloader.base.FailException;
import org.wlf.filedownloader.base.FailReason;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.file_download.file_saver.DownloadNoticeStrategy;
import org.wlf.filedownloader.file_download.file_saver.Save;
import org.wlf.filedownloader.file_download.http_downloader.ContentLengthInputStream;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.MathUtil;

public class FileSaver
implements Save,
Stoppable {
    private static final String TAG = FileSaver.class.getSimpleName();
    private static final int BUFFER_SIZE_WRITE_TO_FILE = 32768;
    private String mUrl;
    private String mTempFilePath;
    private String mSaveFilePath;
    private long mFileTotalSize;
    private int mBufferSizeWriteToFile = 32768;
    private DownloadNoticeStrategy mDownloadNoticeStrategy = DownloadNoticeStrategy.NOTICE_AUTO;
    private boolean mIsStopped;
    private boolean mIsNotifyEnd;
    private OnFileSaveListener mOnFileSaveListener;

    public FileSaver(String url, String tempFilePath, String saveFilePath, long fileTotalSize) {
        this.mUrl = url;
        this.mTempFilePath = tempFilePath;
        this.mSaveFilePath = saveFilePath;
        this.mFileTotalSize = fileTotalSize;
        this.mIsStopped = false;
        this.mIsNotifyEnd = false;
    }

    public void setOnFileSaveListener(OnFileSaveListener onFileSaveListener) {
        this.mOnFileSaveListener = onFileSaveListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveData(ContentLengthInputStream inputStream, long startPosInTotal) throws FileSaveException {
        int needNotifySize;
        String url;
        boolean isCompleted;
        String filePath;
        boolean hasException;
        block27: {
            hasException = true;
            filePath = null;
            isCompleted = false;
            url = this.mUrl;
            byte[] buffer = new byte[this.mBufferSizeWriteToFile];
            int startIndex = 0;
            RandomAccessFile randomAccessFile = null;
            needNotifySize = 0;
            try {
                int readSize;
                this.checkIsStop();
                FileUtil.createFileParentDir(this.mTempFilePath);
                FileUtil.createFileParentDir(this.mSaveFilePath);
                File tempFile = new File(this.mTempFilePath);
                File saveFile = new File(this.mSaveFilePath);
                long handledFileSize = 0L;
                long needHandleSize = inputStream.getLength();
                randomAccessFile = new RandomAccessFile(tempFile, "rwd");
                randomAccessFile.seek(startPosInTotal);
                filePath = tempFile.getAbsolutePath();
                this.notifyStart();
                Log.d(TAG, TAG + ".saveData 1\u3001\u51c6\u5907\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u8def\u5f84\uff1a" + tempFile.getAbsolutePath() + "\uff0curl\uff1a" + url);
                long lastNotifyTime = SystemClock.elapsedRealtime();
                long curTime = SystemClock.elapsedRealtime();
                block13: while (!this.mIsStopped && (readSize = inputStream.read(buffer, startIndex, this.mBufferSizeWriteToFile)) != -1) {
                    if (!tempFile.exists()) {
                        throw new FileSaveException("temp file not exist!", FileSaveException.TYPE_TEMP_FILE_DOES_NOT_EXIST);
                    }
                    randomAccessFile.write(buffer, startIndex, readSize);
                    int increaseSize = readSize - startIndex;
                    handledFileSize += (long)increaseSize;
                    needNotifySize += increaseSize;
                    curTime = SystemClock.elapsedRealtime();
                    long dTime = curTime - lastNotifyTime;
                    switch (this.mDownloadNoticeStrategy) {
                        case NOTICE_AUTO: {
                            long maxNotifySize = (long)((double)needHandleSize * 0.5);
                            if (dTime >= DownloadNoticeStrategy.NOTICE_BY_TIME.getValue()) {
                                Log.d(TAG, TAG + ".saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledFileSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + MathUtil.formatNumber((double)handledFileSize / (double)needHandleSize * 100.0) + "%\uff0curl\uff1a" + url);
                                if (!this.notifySaving(needNotifySize, needHandleSize)) break;
                                needNotifySize = 0;
                                lastNotifyTime = curTime;
                                break;
                            }
                            if ((long)needNotifySize < maxNotifySize) break;
                            Log.d(TAG, TAG + ".saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledFileSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + MathUtil.formatNumber((double)handledFileSize / (double)needHandleSize * 100.0) + "%\uff0curl\uff1a" + url);
                            if (!this.notifySaving(needNotifySize, needHandleSize)) break;
                            needNotifySize = 0;
                            lastNotifyTime = curTime;
                            break;
                        }
                        case NOTICE_BY_SIZE: {
                            if ((long)needNotifySize < this.mDownloadNoticeStrategy.getValue()) break;
                            Log.d(TAG, TAG + ".saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledFileSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + MathUtil.formatNumber((double)handledFileSize / (double)needHandleSize * 100.0) + "%\uff0curl\uff1a" + url);
                            if (!this.notifySaving(needNotifySize, needHandleSize)) break;
                            needNotifySize = 0;
                            lastNotifyTime = curTime;
                            break;
                        }
                        case NOTICE_BY_TIME: {
                            if (dTime < this.mDownloadNoticeStrategy.getValue()) break;
                            Log.d(TAG, TAG + ".saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledFileSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + MathUtil.formatNumber((double)handledFileSize / (double)needHandleSize * 100.0) + "%\uff0curl\uff1a" + url);
                            if (!this.notifySaving(needNotifySize, needHandleSize)) break;
                            needNotifySize = 0;
                            lastNotifyTime = curTime;
                            continue block13;
                        }
                    }
                }
                if (needNotifySize > 0) {
                    Log.d(TAG, TAG + ".saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledFileSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + MathUtil.formatNumber((double)handledFileSize / (double)needHandleSize * 100.0) + "%\uff0curl\uff1a" + url);
                    if (this.notifySaving(needNotifySize, needHandleSize)) {
                        needNotifySize = 0;
                        lastNotifyTime = curTime;
                    }
                }
                if (needHandleSize == handledFileSize && tempFile.length() == this.mFileTotalSize) {
                    boolean deleteResult;
                    if (saveFile.exists() && !(deleteResult = saveFile.delete())) {
                        throw new FileSaveException("delete old file:" + saveFile.getAbsolutePath() + " failed!", FileSaveException.TYPE_FILE_CAN_NOT_STORAGE);
                    }
                    isCompleted = tempFile.renameTo(saveFile);
                    if (!isCompleted) {
                        isCompleted = FileUtil.copyFile(tempFile, saveFile, true);
                    }
                    if (!isCompleted) {
                        throw new FileSaveException("rename temp file:" + tempFile.getAbsolutePath() + " to save " + saveFile.getAbsolutePath() + " failed!", FileSaveException.TYPE_RENAME_TEMP_FILE_ERROR);
                    }
                    filePath = saveFile.getAbsolutePath();
                    Log.d(TAG, TAG + ".saveData 3\u3001\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6210\uff0c\u8def\u5f84\uff1a" + saveFile.getAbsolutePath() + "\uff0curl\uff1a" + url);
                } else if (!this.mIsStopped) {
                    throw new FileSaveException("saving data error!", FileSaveException.TYPE_UNKNOWN);
                }
                hasException = false;
                if (randomAccessFile == null) break block27;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    hasException = false;
                    if (!(e instanceof FileSaveException)) throw new FileSaveException(e);
                    throw (FileSaveException)e;
                }
                catch (Throwable throwable) {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (!hasException) {
                        this.notifyEnd(needNotifySize, isCompleted);
                    }
                    this.mIsStopped = true;
                    Log.d(TAG, TAG + ".saveData 3\u3001\u6587\u4ef6\u4fdd\u5b58\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0c\u4fdd\u5b58\u8def\u5f84\uff1a" + filePath + "\uff0curl\uff1a" + url);
                    throw throwable;
                }
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!hasException) {
            this.notifyEnd(needNotifySize, isCompleted);
        }
        this.mIsStopped = true;
        Log.d(TAG, TAG + ".saveData 3\u3001\u6587\u4ef6\u4fdd\u5b58\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0c\u4fdd\u5b58\u8def\u5f84\uff1a" + filePath + "\uff0curl\uff1a" + url);
    }

    private void notifyStart() {
        if (this.mOnFileSaveListener != null) {
            this.mOnFileSaveListener.onSaveDataStart();
        }
        Log.i(TAG, "file-downloader-save \u51c6\u5907\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
    }

    private boolean notifySaving(int needNotifySize, long needHandleSize) {
        if (this.mOnFileSaveListener != null) {
            this.mOnFileSaveListener.onSavingData(needNotifySize, needHandleSize);
            Log.i(TAG, "file-downloader-save \u6b63\u5728\u4fdd\u5b58\u6570\u636e\uff0cneedNotifySize\uff1a" + needNotifySize + "\uff0cneedHandleSize\uff1a" + needHandleSize);
            return true;
        }
        return false;
    }

    private void notifyEnd(int increaseSize, boolean complete) {
        if (this.mIsNotifyEnd) {
            return;
        }
        if (this.mOnFileSaveListener != null) {
            this.mOnFileSaveListener.onSaveDataEnd(increaseSize, complete);
        }
        this.mIsNotifyEnd = true;
        Log.i(TAG, "file-downloader-save \u4fdd\u5b58\u6570\u636e\u5b8c\u6210\uff0c\u662f\u5426\u6574\u4e2a\u6587\u4ef6\u5168\u90e8\u4e0b\u8f7d\u5b8c\u6210\uff1a" + complete);
    }

    private void checkIsStop() throws FileSaveException {
        if (this.isStopped()) {
            Log.e(TAG, TAG + ".checkIsStop --\u5df2\u7ecf\u5904\u7406\u5b8c\u4e86/\u5f3a\u5236\u505c\u6b62\u4e86\uff0c\u4e0d\u80fd\u518d\u5904\u7406\u6570\u636e\uff01");
            throw new FileSaveException("the file saver has been stopped,it can not handle data any more!", FileSaveException.TYPE_SAVER_HAS_BEEN_STOPPED);
        }
    }

    @Override
    public void stop() {
        this.mIsStopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.mIsStopped;
    }

    public static interface OnFileSaveListener {
        public void onSaveDataStart();

        public void onSavingData(int var1, long var2);

        public void onSaveDataEnd(int var1, boolean var2);
    }

    public static class FileSaveException
    extends FailException {
        public static final String TYPE_RENAME_TEMP_FILE_ERROR = FileSaveException.class.getName() + "_TYPE_RENAME_TEMP_FILE_ERROR";
        public static final String TYPE_SAVER_HAS_BEEN_STOPPED = FileSaveException.class.getName() + "_TYPE_SAVER_HAS_BEEN_STOPPED";
        public static final String TYPE_TEMP_FILE_DOES_NOT_EXIST = FileSaveException.class.getName() + "_TYPE_TEMP_FILE_DOES_NOT_EXIST";
        public static final String TYPE_FILE_CAN_NOT_STORAGE = FileSaveException.class.getName() + "_TYPE_FILE_CAN_NOT_STORAGE";

        public FileSaveException(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public FileSaveException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
            if (this.isTypeInit() || throwable == null) {
                return;
            }
            if (throwable instanceof FailReason) {
                FailReason failReason = (FailReason)throwable;
                this.setTypeByOriginalClassInstanceType(failReason.getOriginalCause());
                if (this.isTypeInit()) {
                    return;
                }
            } else {
                this.setTypeByOriginalClassInstanceType(throwable);
            }
        }

        private void setTypeByOriginalClassInstanceType(Throwable throwable) {
            if (throwable == null) {
                return;
            }
            if (throwable instanceof IOException) {
                // empty if block
            }
        }
    }
}

