/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wlf.filedownloader.db.ContentDbDao;
import org.wlf.filedownloader.util.CollectionUtil;

public abstract class BaseContentDbHelper
extends SQLiteOpenHelper {
    private Map<String, ContentDbDao> mContentDbDaoMap = new HashMap<String, ContentDbDao>();

    public BaseContentDbHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.initContentDbDaoMap();
    }

    private void initContentDbDaoMap() {
        ArrayList<ContentDbDao> contentDbDaos = new ArrayList<ContentDbDao>();
        this.onConfigContentDbDaos(contentDbDaos);
        if (CollectionUtil.isEmpty(contentDbDaos)) {
            return;
        }
        for (ContentDbDao contentDbDao : contentDbDaos) {
            String tableName;
            if (contentDbDao == null || TextUtils.isEmpty((CharSequence)(tableName = contentDbDao.getTableName())) || this.mContentDbDaoMap.containsKey(tableName)) continue;
            this.mContentDbDaoMap.put(tableName, contentDbDao);
        }
    }

    public void onCreate(SQLiteDatabase db) {
        Collection<ContentDbDao> contentDbDaos = this.mContentDbDaoMap.values();
        if (CollectionUtil.isEmpty(contentDbDaos)) {
            return;
        }
        for (ContentDbDao contentDbDao : contentDbDaos) {
            if (contentDbDao == null) continue;
            contentDbDao.onCreate(db);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Collection<ContentDbDao> contentDbDaos = this.mContentDbDaoMap.values();
        if (CollectionUtil.isEmpty(contentDbDaos)) {
            return;
        }
        for (ContentDbDao contentDbDao : contentDbDaos) {
            if (contentDbDao == null) continue;
            contentDbDao.onUpgrade(db, oldVersion, newVersion);
        }
    }

    protected abstract void onConfigContentDbDaos(List<ContentDbDao> var1);

    public ContentDbDao getContentDbDao(String tableName) {
        if (!this.mContentDbDaoMap.containsKey(tableName)) {
            throw new RuntimeException("unregistered database table:" + tableName + " in " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        return this.mContentDbDaoMap.get(tableName);
    }
}

