/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.File;

public class FileUtil {
    public static final boolean createFileParentDir(String filePath) {
        File file = new File(filePath);
        if (file != null) {
            if (file.exists()) {
                return true;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                if (parentFile.exists()) {
                    return true;
                }
                return parentFile.mkdirs();
            }
        }
        return false;
    }

    public static String getFileSuffix(String filePath) {
        int start;
        if (!TextUtils.isEmpty((CharSequence)filePath) && (start = filePath.lastIndexOf(".")) != -1) {
            return filePath.substring(start + 1);
        }
        return null;
    }

    public static boolean isFilePath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith(File.separator);
    }

    public static final boolean canWrite(String path) {
        if (FileUtil.isSDCardPath(path)) {
            return "mounted".equals(Environment.getExternalStorageState());
        }
        return true;
    }

    public static final boolean isSDCardPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String sdRootPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return path.startsWith(sdRootPath);
    }

    public static long getAvailableSpace(String fileDirPath) {
        try {
            StatFs stats = new StatFs(fileDirPath);
            long result = (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }
}

