/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.io.File;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.util.FileUtil;

class MoveDownloadFileTask
implements Runnable {
    private static final String TAG = MoveDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private String mNewDirPath;
    private DownloadFileCacher mFileDownloadCacher;
    private boolean mIsSyncCallback = false;
    private OnMoveDownloadFileListener mOnMoveDownloadFileListener;

    MoveDownloadFileTask(String url, String newDirPath, DownloadFileCacher fileDownloadCacher) {
        this.mUrl = url;
        this.mNewDirPath = newDirPath;
        this.mFileDownloadCacher = fileDownloadCacher;
    }

    void setOnMoveDownloadFileListener(OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.mOnMoveDownloadFileListener = onMoveDownloadFileListener;
    }

    void enableSyncCallback() {
        this.mIsSyncCallback = true;
    }

    @Override
    public void run() {
        DownloadFileInfo downloadFileInfo = this.mFileDownloadCacher.getDownloadFile(this.mUrl);
        if (downloadFileInfo == null) {
            this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the DownloadFile is empty!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_NULL_POINTER));
            return;
        }
        this.notifyPrepared(downloadFileInfo);
        File oldFile = null;
        File newFile = null;
        switch (downloadFileInfo.getStatus()) {
            case 5: {
                oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getFileName());
                newFile = new File(this.mNewDirPath, downloadFileInfo.getFileName());
                break;
            }
            case 6: {
                oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                newFile = new File(this.mNewDirPath, downloadFileInfo.getTempFileName());
                break;
            }
            default: {
                this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("DownloadFile status error!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_FILE_STATUS_ERROR));
                return;
            }
        }
        if (oldFile == null || !oldFile.exists()) {
            this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the original file does not exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST));
            return;
        }
        if (newFile != null && newFile.exists()) {
            this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the target file exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_TARGET_FILE_EXIST));
            return;
        }
        if (newFile != null && !newFile.getParentFile().exists()) {
            FileUtil.createFileParentDir(newFile.getAbsolutePath());
        }
        String oldDirPath = downloadFileInfo.getFileDir();
        boolean moveResult = false;
        downloadFileInfo.setFileDir(this.mNewDirPath);
        moveResult = this.mFileDownloadCacher.updateDownloadFile(downloadFileInfo);
        if (moveResult) {
            moveResult = oldFile.renameTo(newFile);
            if (moveResult) {
                this.notifySuccess(downloadFileInfo);
            } else {
                downloadFileInfo.setFileDir(oldDirPath);
                this.mFileDownloadCacher.updateDownloadFile(downloadFileInfo);
                this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("update record error!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_UPDATE_RECORD_ERROR));
            }
        } else {
            this.notifyFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("update record error!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_UPDATE_RECORD_ERROR));
        }
    }

    private void notifyPrepared(DownloadFileInfo downloadFileInfo) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFilePrepared(downloadFileInfo);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFilePrepared(downloadFileInfo, this.mOnMoveDownloadFileListener);
        }
    }

    private void notifySuccess(DownloadFileInfo downloadFileInfo) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFileSuccess(downloadFileInfo);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileSuccess(downloadFileInfo, this.mOnMoveDownloadFileListener);
        }
    }

    private void notifyFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.OnMoveDownloadFileFailReason failReason) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, failReason);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, failReason, this.mOnMoveDownloadFileListener);
        }
    }
}

