/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.file_saver.FileSaver;
import org.wlf.filedownloader.listener.HttpFailReason;

public interface OnFileDownloadStatusListener {
    public void onFileDownloadStatusWaiting(DownloadFileInfo var1);

    public void onFileDownloadStatusPreparing(DownloadFileInfo var1);

    public void onFileDownloadStatusPrepared(DownloadFileInfo var1);

    public void onFileDownloadStatusDownloading(DownloadFileInfo var1, float var2, long var3);

    public void onFileDownloadStatusPaused(DownloadFileInfo var1);

    public void onFileDownloadStatusCompleted(DownloadFileInfo var1);

    public void onFileDownloadStatusFailed(String var1, DownloadFileInfo var2, OnFileDownloadStatusFailReason var3);

    public static class OnFileDownloadStatusFailReason
    extends HttpFailReason {
        private static final long serialVersionUID = -8178297554707996481L;
        public static final String TYPE_URL_ILLEGAL = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_URL_ILLEGAL";
        public static final String TYPE_FILE_SAVE_PATH_ILLEGAL = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_SAVE_PATH_ILLEGAL";
        public static final String TYPE_STORAGE_SPACE_CAN_NOT_WRITE = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_STORAGE_SPACE_CAN_NOT_WRITE";
        public static final String TYPE_STORAGE_SPACE_IS_FULL = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_STORAGE_SPACE_IS_FULL";
        public static final String TYPE_FILE_NOT_DETECT = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_NOT_DETECT";
        public static final String TYPE_FILE_IS_DOWNLOADING = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_IS_DOWNLOADING";
        public static final String TYPE_DOWNLOAD_FILE_ERROR = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_DOWNLOAD_FILE_ERROR";
        public static final String TYPE_SAVE_FILE_NOT_EXIST = OnFileDownloadStatusFailReason.class.getName() + "_TYPE_SAVE_FILE_NOT_EXIST";

        public OnFileDownloadStatusFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnFileDownloadStatusFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
            if (this.isTypeInit()) {
                return;
            }
            if (throwable instanceof FileSaver.FileSaveException) {
                FileSaver.FileSaveException fileSaveException = (FileSaver.FileSaveException)throwable;
                String type = fileSaveException.getType();
                if (FileSaver.FileSaveException.TYPE_FILE_DOES_NOT_EXIST.equals(type)) {
                    this.setType(TYPE_SAVE_FILE_NOT_EXIST);
                } else if (FileSaver.FileSaveException.TYPE_SAVER_IS_STOPPED.equals(type)) {
                    // empty if block
                }
            }
        }
    }

    public static class MainThreadHelper {
        public static void onFileDownloadStatusWaiting(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusWaiting(downloadFileInfo);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusPreparing(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusPreparing(downloadFileInfo);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusPrepared(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusPrepared(downloadFileInfo);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusDownloading(final DownloadFileInfo downloadFileInfo, final float downloadSpeed, final long remainingTime, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusPaused(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusPaused(downloadFileInfo);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusCompleted(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusCompleted(downloadFileInfo);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onFileDownloadStatusFailed(final String url, final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusFailReason failReason, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onFileDownloadStatusListener.onFileDownloadStatusFailed(url, downloadFileInfo, failReason);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }
}

