/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;

class DownloadFileChangeObserver
implements OnDownloadFileChangeListener {
    private Set<WeakReference<OnDownloadFileChangeListener>> mWeakOnDownloadFileChangeListeners = new CopyOnWriteArraySet<WeakReference<OnDownloadFileChangeListener>>();

    DownloadFileChangeObserver() {
    }

    void addOnDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        for (WeakReference<OnDownloadFileChangeListener> weakReference : this.mWeakOnDownloadFileChangeListeners) {
            OnDownloadFileChangeListener weakListener;
            if (weakReference == null || (weakListener = (OnDownloadFileChangeListener)weakReference.get()) == null || weakListener != onDownloadFileChangeListener) continue;
            return;
        }
        WeakReference<OnDownloadFileChangeListener> weakReference = new WeakReference<OnDownloadFileChangeListener>(onDownloadFileChangeListener);
        this.mWeakOnDownloadFileChangeListeners.add(weakReference);
    }

    void removeOnDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        for (WeakReference<OnDownloadFileChangeListener> weakReference : this.mWeakOnDownloadFileChangeListeners) {
            OnDownloadFileChangeListener weakListener;
            if (weakReference == null || (weakListener = (OnDownloadFileChangeListener)weakReference.get()) == null || weakListener != onDownloadFileChangeListener) continue;
            this.mWeakOnDownloadFileChangeListeners.remove(weakListener);
            break;
        }
    }

    void release() {
        this.mWeakOnDownloadFileChangeListeners.clear();
    }

    @Override
    public void onDownloadFileCreated(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnDownloadFileChangeListener> weakReference : this.mWeakOnDownloadFileChangeListeners) {
            OnDownloadFileChangeListener weakListener;
            if (weakReference == null || (weakListener = (OnDownloadFileChangeListener)weakReference.get()) == null || weakListener == this) continue;
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileCreated(downloadFileInfo, weakListener);
        }
    }

    @Override
    public void onDownloadFileUpdated(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener.Type type) {
        for (WeakReference<OnDownloadFileChangeListener> weakReference : this.mWeakOnDownloadFileChangeListeners) {
            OnDownloadFileChangeListener weakListener;
            if (weakReference == null || (weakListener = (OnDownloadFileChangeListener)weakReference.get()) == null || weakListener == this) continue;
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileUpdated(downloadFileInfo, type, weakListener);
        }
    }

    @Override
    public void onDownloadFileDeleted(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnDownloadFileChangeListener> weakReference : this.mWeakOnDownloadFileChangeListeners) {
            OnDownloadFileChangeListener weakListener;
            if (weakReference == null || (weakListener = (OnDownloadFileChangeListener)weakReference.get()) == null || weakListener == this) continue;
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileDeleted(downloadFileInfo, weakListener);
        }
    }
}

