/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlUtil {
    public static boolean isUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        String encodedUrl = UrlUtil.getEncoderUrl(url, "UTF-8");
        return !TextUtils.isEmpty((CharSequence)encodedUrl);
    }

    public static String getEncoderUrl(String url, String charset) {
        int start = url.lastIndexOf("/");
        if (start == -1) {
            return null;
        }
        String needEncode = url.substring(start + 1, url.length());
        String needEncodeUrl = null;
        try {
            needEncodeUrl = URLEncoder.encode(needEncode, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (needEncodeUrl != null) {
            needEncodeUrl = needEncodeUrl.replace("+", "%20");
        }
        String encodedUrl = url.substring(0, start) + "/" + needEncodeUrl;
        return encodedUrl;
    }
}

