/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.http_downlaoder;

import android.text.TextUtils;

public class ContentRangeInfo {
    public final String contentType;
    public final int startPos;
    public final int endPos;
    public final int totalLength;

    private ContentRangeInfo(String contentType, int startPos, int endPos, int totalLength) {
        this.contentType = contentType;
        this.startPos = startPos;
        this.endPos = endPos;
        this.totalLength = totalLength;
    }

    public static ContentRangeInfo getContentRangeInfo(String contentRangeStr) {
        String[] contentRangeStrArrayTemp;
        ContentRangeInfo contentRangeInfo = null;
        String contentType = null;
        String rangeStartPos = null;
        String rangeEndPos = null;
        String totalLength = null;
        if (!TextUtils.isEmpty((CharSequence)contentRangeStr) && (contentRangeStrArrayTemp = contentRangeStr.split(" ")) != null && contentRangeStrArrayTemp.length >= 2) {
            String[] contentRangeAndLengthArrayTemp;
            contentType = contentRangeStrArrayTemp[0];
            String contentRangeAndLength = contentRangeStrArrayTemp[1];
            if (!TextUtils.isEmpty((CharSequence)contentRangeAndLength) && (contentRangeAndLengthArrayTemp = contentRangeAndLength.split("/")) != null && contentRangeAndLengthArrayTemp.length >= 2) {
                String contentRanges = contentRangeAndLengthArrayTemp[0];
                String[] contentRangesArrayTemp = contentRanges.split("-");
                if (contentRangesArrayTemp != null && contentRangesArrayTemp.length >= 2) {
                    rangeStartPos = contentRangesArrayTemp[0];
                    rangeEndPos = contentRangesArrayTemp[1];
                }
                totalLength = contentRangeAndLengthArrayTemp[1];
            }
        }
        if (!(TextUtils.isEmpty(contentType) || TextUtils.isEmpty(rangeStartPos) || TextUtils.isEmpty(rangeEndPos) || TextUtils.isEmpty(totalLength))) {
            try {
                int startPos = Integer.parseInt(rangeStartPos);
                int endPos = Integer.parseInt(rangeEndPos);
                int totalLen = Integer.parseInt(totalLength);
                contentRangeInfo = new ContentRangeInfo(contentType.trim(), startPos, endPos + 1, totalLen);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return contentRangeInfo;
    }
}

