/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.db;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import org.wlf.filedownloader.db.ContentDbDao;

public abstract class BaseContentProvider
extends ContentProvider {
    private String mAuthority;
    private String mMimeTypeRow;
    private String mMimeTypeRows;
    private ContentDbDao mContentDbDaoImpl;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final int ROW = 1;
    private static final int ROWS = 2;

    protected abstract String onCreateAuthority();

    protected abstract ContentDbDao onCreateContentDbDao();

    private static final String createContentProviderUri(String authority, String tableName) {
        return "content://" + authority + "/" + tableName;
    }

    public boolean onCreate() {
        this.mAuthority = this.onCreateAuthority();
        this.mContentDbDaoImpl = this.onCreateContentDbDao();
        String tableName = this.mContentDbDaoImpl.getTableName();
        this.mMimeTypeRow = "vnd.android.cursor.item/" + tableName;
        this.mMimeTypeRows = "vnd.android.cursor.dir/" + tableName + "s";
        URI_MATCHER.addURI(this.mAuthority, tableName + "/#", 1);
        URI_MATCHER.addURI(this.mAuthority, tableName, 2);
        return !TextUtils.isEmpty((CharSequence)this.mAuthority) && !TextUtils.isEmpty((CharSequence)tableName) && this.mContentDbDaoImpl.getTableIdFieldName() != null;
    }

    public String getType(Uri uri) {
        int flag = URI_MATCHER.match(uri);
        switch (flag) {
            case 1: {
                return this.mMimeTypeRow;
            }
            case 2: {
                return this.mMimeTypeRows;
            }
        }
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Uri resultUri = null;
        try {
            int flag = URI_MATCHER.match(uri);
            switch (flag) {
                case 1: 
                case 2: {
                    long id = this.mContentDbDaoImpl.insert(values);
                    resultUri = ContentUris.withAppendedId((Uri)uri, (long)id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultUri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = -1;
        try {
            int flag = URI_MATCHER.match(uri);
            switch (flag) {
                case 1: {
                    long id = ContentUris.parseId((Uri)uri);
                    String whereValue = this.mContentDbDaoImpl.getTableIdFieldName() + " = ?";
                    String[] args = new String[]{String.valueOf(id)};
                    count = this.mContentDbDaoImpl.delete(whereValue, args);
                    break;
                }
                case 2: {
                    count = this.mContentDbDaoImpl.delete(selection, selectionArgs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = -1;
        try {
            int flag = URI_MATCHER.match(uri);
            switch (flag) {
                case 1: {
                    long id = ContentUris.parseId((Uri)uri);
                    String whereValue = this.mContentDbDaoImpl.getTableIdFieldName() + " = ?";
                    String[] args = new String[]{String.valueOf(id)};
                    count = this.mContentDbDaoImpl.update(values, whereValue, args);
                    break;
                }
                case 2: {
                    count = this.mContentDbDaoImpl.update(values, selection, selectionArgs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor = null;
        try {
            int flag = URI_MATCHER.match(uri);
            switch (flag) {
                case 1: {
                    long id = ContentUris.parseId((Uri)uri);
                    String whereValue = this.mContentDbDaoImpl.getTableIdFieldName() + " = ?";
                    String[] args = new String[]{String.valueOf(id)};
                    cursor = this.mContentDbDaoImpl.query(null, whereValue, args, null);
                    break;
                }
                case 2: {
                    cursor = this.mContentDbDaoImpl.query(projection, selection, selectionArgs, sortOrder);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cursor;
    }
}

