/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.wlf.filedownloader.db.ContentDbDao;
import org.wlf.filedownloader.db.DatabaseCallback;

public abstract class BaseContentDbDao
implements ContentDbDao,
DatabaseCallback {
    public static final String DEFAULT_TABLE_ID_FIELD_NAME = "_id";
    private SQLiteOpenHelper mDbHelper;
    private String mTableName;
    private String mTableIdFieldName = "_id";

    public BaseContentDbDao(SQLiteOpenHelper dbHelper, String tableName, String tableIdFieldName) {
        this.mDbHelper = dbHelper;
        this.mTableName = tableName;
        this.mTableIdFieldName = tableIdFieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentValues values) {
        long id = -1L;
        SQLiteDatabase database = null;
        try {
            database = this.mDbHelper.getWritableDatabase();
            id = database.insert(this.mTableName, null, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String selection, String[] selectionArgs) {
        int count = -1;
        SQLiteDatabase database = null;
        try {
            database = this.mDbHelper.getWritableDatabase();
            count = database.delete(this.mTableName, selection, selectionArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase database = null;
        int count = -1;
        try {
            database = this.mDbHelper.getWritableDatabase();
            count = database.update(this.mTableName, values, selection, selectionArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor query(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase database = null;
        Cursor cursor = null;
        try {
            database = this.mDbHelper.getReadableDatabase();
            cursor = database.query(true, this.mTableName, null, selection, selectionArgs, null, null, sortOrder, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cursor;
    }

    @Override
    public String getTableName() {
        return this.mTableName;
    }

    @Override
    public String getTableIdFieldName() {
        return this.mTableIdFieldName;
    }
}

