/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileDownloadConfiguration {
    private static final String TAG = FileDownloadConfiguration.class.getSimpleName();
    private Context mContext;
    private String mFileDownloadDir;
    private ExecutorService mFileDownloadEngine;
    private ExecutorService mSupportEngine;

    public static FileDownloadConfiguration createDefault(Context context) {
        return new Builder(context).build();
    }

    private FileDownloadConfiguration(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder can not be empty!");
        }
        this.mContext = builder.mContext;
        this.mFileDownloadDir = builder.mFileDownloadDir;
        this.mFileDownloadEngine = Executors.newFixedThreadPool(builder.mDownloadTaskSize);
        this.mSupportEngine = Executors.newSingleThreadExecutor();
    }

    Context getContext() {
        return this.mContext;
    }

    String getFileDownloadDir() {
        return this.mFileDownloadDir;
    }

    ExecutorService getFileDownloadEngine() {
        return this.mFileDownloadEngine;
    }

    ExecutorService getSupportEngine() {
        return this.mSupportEngine;
    }

    public static class Builder {
        public static final int MAX_DOWNLOAD_TASK_SIZE = 10;
        public static final int DEFAULT_DOWNLOAD_TASK_SIZE = 2;
        private Context mContext;
        private String mFileDownloadDir;
        private int mDownloadTaskSize = -1;

        public Builder(Context context) {
            this.mContext = context.getApplicationContext();
            try {
                this.mFileDownloadDir = this.mContext.getExternalFilesDir(null).getAbsolutePath() + File.separator + "file_downloader";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFileDownloadDir = this.mContext.getFilesDir().getAbsolutePath() + File.separator + "file_downloader";
            }
            this.mDownloadTaskSize = 2;
        }

        public Builder configFileDownloadDir(String fileDownloadDir) {
            if (!TextUtils.isEmpty((CharSequence)fileDownloadDir)) {
                File file = new File(fileDownloadDir);
                if (!file.exists()) {
                    Log.i((String)TAG, (String)("configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u8fd8\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa\uff01"));
                    boolean isCreateSuccess = file.mkdirs();
                    if (isCreateSuccess) {
                        Log.i((String)TAG, (String)("configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u521b\u5efa\u6210\u529f\uff01"));
                    } else {
                        Log.i((String)TAG, (String)("configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u521b\u5efa\u5931\u8d25\uff01"));
                    }
                } else {
                    Log.i((String)TAG, (String)("configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u5df2\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u521b\u5efa\uff01"));
                }
                this.mFileDownloadDir = fileDownloadDir;
            }
            return this;
        }

        public Builder configDownloadTaskSize(int downloadTaskSize) {
            if (downloadTaskSize > 0 && downloadTaskSize <= 10) {
                this.mDownloadTaskSize = downloadTaskSize;
            } else if (downloadTaskSize > 10) {
                this.mDownloadTaskSize = 10;
            } else {
                Log.i((String)TAG, (String)("configDownloadTaskSize \u914d\u7f6e\u540c\u65f6\u4e0b\u8f7d\u4efb\u52a1\u7684\u6570\u91cf\u5931\u8d25\uff0cdownloadTaskSize\uff1a" + downloadTaskSize));
            }
            return this;
        }

        public FileDownloadConfiguration build() {
            return new FileDownloadConfiguration(this);
        }
    }
}

