/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.util.Log;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadTaskManager;
import org.wlf.filedownloader.FileDownloadTask;
import org.wlf.filedownloader.RenameDownloadFileTask;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;

class DownloadRenameManager {
    private static final String TAG = DownloadRenameManager.class.getSimpleName();
    private ExecutorService mSupportEngine;
    private DownloadFileCacher mDownloadFileCacher;
    private DownloadTaskManager mDownloadTaskManager;

    DownloadRenameManager(ExecutorService supportEngine, DownloadFileCacher downloadFileCacher, DownloadTaskManager downloadTaskManager) {
        this.mSupportEngine = supportEngine;
        this.mDownloadFileCacher = downloadFileCacher;
        this.mDownloadTaskManager = downloadTaskManager;
    }

    private void addAndRunTask(Runnable task) {
        this.mSupportEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    private void renameInternal(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        RenameDownloadFileTask task = new RenameDownloadFileTask(url, newFileName, includedSuffix, this.mDownloadFileCacher);
        task.setOnRenameDownloadFileListener(onRenameDownloadFileListener);
        this.addAndRunTask(task);
    }

    void rename(String url, final String newFileName, final boolean includedSuffix, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("rename \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onRenameDownloadFileListener != null) {
                onRenameDownloadFileListener.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the download file is not exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST));
            }
            return;
        }
        if (!this.mDownloadTaskManager.isInFileDownloadTaskMap(url)) {
            Log.d((String)TAG, (String)("rename \u76f4\u63a5\u91cd\u547d\u540d,url:" + url));
            this.renameInternal(url, newFileName, includedSuffix, onRenameDownloadFileListener);
        } else {
            Log.d((String)TAG, (String)("rename \u9700\u8981\u5148\u6682\u505c\u540e\u91cd\u547d\u540d,url:" + url));
            this.mDownloadTaskManager.pause(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("rename \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u91cd\u547d\u540d,url:" + url));
                    DownloadRenameManager.this.renameInternal(url, newFileName, includedSuffix, onRenameDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("rename \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u91cd\u547d\u540d,url:" + url));
                    if (onRenameDownloadFileListener != null) {
                        onRenameDownloadFileListener.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason(failReason));
                    }
                }
            });
        }
    }
}

