/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadTaskManager;
import org.wlf.filedownloader.FileDownloadTask;
import org.wlf.filedownloader.MoveDownloadFileTask;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadMoveManager {
    private static final String TAG = DownloadMoveManager.class.getSimpleName();
    private ExecutorService mSupportEngine;
    private DownloadFileCacher mDownloadFileCacher;
    private DownloadTaskManager mDownloadTaskManager;
    private MoveDownloadFilesTask mMoveDownloadFilesTask;

    DownloadMoveManager(ExecutorService supportEngine, DownloadFileCacher downloadFileCacher, DownloadTaskManager downloadTaskManager) {
        this.mSupportEngine = supportEngine;
        this.mDownloadFileCacher = downloadFileCacher;
        this.mDownloadTaskManager = downloadTaskManager;
    }

    private void addAndRunTask(Runnable task) {
        this.mSupportEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    private void moveInternal(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener, boolean isSyncCallback) {
        MoveDownloadFileTask moveDownloadFileTask = new MoveDownloadFileTask(url, newDirPath, this.mDownloadFileCacher);
        if (isSyncCallback) {
            moveDownloadFileTask.enableSyncCallback();
        }
        moveDownloadFileTask.setOnMoveDownloadFileListener(onMoveDownloadFileListener);
        this.addAndRunTask(moveDownloadFileTask);
    }

    private void move(String url, final String newDirPath, final OnMoveDownloadFileListener onMoveDownloadFileListener, final boolean isSyncCallback) {
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("move \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onMoveDownloadFileListener != null) {
                onMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the download file doest not exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST));
            }
            return;
        }
        if (!this.mDownloadTaskManager.isInFileDownloadTaskMap(url)) {
            Log.d((String)TAG, (String)("move \u76f4\u63a5\u79fb\u52a8,url:" + url));
            this.moveInternal(url, newDirPath, onMoveDownloadFileListener, isSyncCallback);
        } else {
            Log.d((String)TAG, (String)("move \u9700\u8981\u5148\u6682\u505c\u540e\u79fb\u52a8,url:" + url));
            this.mDownloadTaskManager.pause(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("move \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u79fb\u52a8,url:" + url));
                    DownloadMoveManager.this.moveInternal(url, newDirPath, onMoveDownloadFileListener, isSyncCallback);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("move \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u79fb\u52a8,url:" + url));
                    if (onMoveDownloadFileListener != null) {
                        OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(failReason), onMoveDownloadFileListener);
                    }
                }
            });
        }
    }

    void move(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.move(url, newDirPath, onMoveDownloadFileListener, false);
    }

    Control move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        if (this.mMoveDownloadFilesTask != null && !this.mMoveDownloadFilesTask.isStopped()) {
            return new MoveControl(this.mMoveDownloadFilesTask);
        }
        MoveDownloadFilesTask moveDownloadFilesTask = new MoveDownloadFilesTask(urls, newDirPath);
        moveDownloadFilesTask.setOnMoveDownloadFilesListener(onMoveDownloadFilesListener);
        this.addAndRunTask(moveDownloadFilesTask);
        this.mMoveDownloadFilesTask = moveDownloadFilesTask;
        return new MoveControl(this.mMoveDownloadFilesTask);
    }

    static class MoveControl
    implements Control {
        private MoveDownloadFilesTask mMoveDownloadFilesTask;

        private MoveControl(MoveDownloadFilesTask moveDownloadFilesTask) {
            this.mMoveDownloadFilesTask = moveDownloadFilesTask;
        }

        @Override
        public void stop() {
            if (this.mMoveDownloadFilesTask != null) {
                this.mMoveDownloadFilesTask.stop();
            }
        }

        @Override
        public boolean isStopped() {
            if (this.mMoveDownloadFilesTask == null) {
                return true;
            }
            return this.mMoveDownloadFilesTask.isStopped();
        }
    }

    private class MoveDownloadFilesTask
    implements Runnable,
    Stoppable {
        private List<String> mUrls;
        private String mNewDirPath;
        private Map<String, String> mOldFileDir = new HashMap<String, String>();
        private OnMoveDownloadFilesListener mOnMoveDownloadFilesListener;
        private boolean mIsStop = false;
        private boolean mCompleted = false;
        final List<DownloadFileInfo> mDownloadFilesNeedMove = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesMoved = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

        public MoveDownloadFilesTask(List<String> urls, String newDirPath) {
            this.mUrls = urls;
            this.mNewDirPath = newDirPath;
        }

        public void setOnMoveDownloadFilesListener(OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
            this.mOnMoveDownloadFilesListener = onMoveDownloadFilesListener;
        }

        @Override
        public void stop() {
            this.mIsStop = true;
        }

        @Override
        public boolean isStopped() {
            return this.mIsStop;
        }

        @Override
        public void run() {
            DownloadFileInfo downloadFileInfo;
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = DownloadMoveManager.this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedMove.add(downloadFileInfo);
                if (TextUtils.isEmpty((CharSequence)downloadFileInfo.getUrl())) continue;
                this.mOldFileDir.put(downloadFileInfo.getUrl(), downloadFileInfo.getFileDir());
            }
            if (this.mOnMoveDownloadFilesListener != null) {
                Log.d((String)TAG, (String)("MoveDownloadFilesTask.run \u51c6\u5907\u6279\u91cf\u79fb\u52a8\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedMove.size()));
                OnMoveDownloadFilesListener.MainThreadHelper.onMoveDownloadFilesPrepared(this.mDownloadFilesNeedMove, this.mOnMoveDownloadFilesListener);
            }
            OnMoveDownloadFileListener onMoveDownloadFileListener = new OnMoveDownloadFileListener(){
                private int deleteCount = 0;

                @Override
                public void onMoveDownloadFilePrepared(DownloadFileInfo downloadFileNeedToMove) {
                    String url = null;
                    if (downloadFileNeedToMove != null) {
                        url = downloadFileNeedToMove.getUrl();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run \u51c6\u5907\u5220\u9664\uff0curl\uff1a" + url));
                    if (MoveDownloadFilesTask.this.mOnMoveDownloadFilesListener != null) {
                        OnMoveDownloadFilesListener.MainThreadHelper.onMovingDownloadFiles(MoveDownloadFilesTask.this.mDownloadFilesNeedMove, MoveDownloadFilesTask.this.mDownloadFilesMoved, MoveDownloadFilesTask.this.mDownloadFilesSkip, downloadFileNeedToMove, MoveDownloadFilesTask.this.mOnMoveDownloadFilesListener);
                    }
                    ++this.deleteCount;
                }

                @Override
                public void onMoveDownloadFileSuccess(DownloadFileInfo downloadFileMoved) {
                    String url = null;
                    if (downloadFileMoved != null) {
                        url = downloadFileMoved.getUrl();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run onMoveDownloadFileSuccess,\u79fb\u52a8\u6210\u529f\uff0cmoveCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedMove.size():" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0curl\uff1a" + url));
                    MoveDownloadFilesTask.this.mDownloadFilesMoved.add(downloadFileMoved);
                    if (this.deleteCount == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() - MoveDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"MoveDownloadFilesTask.run onMoveDownloadFileSuccess,\u79fb\u52a8\u6210\u529f\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                        MoveDownloadFilesTask.this.onMoveDownloadFilesCompleted();
                    }
                }

                @Override
                public void onMoveDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.OnMoveDownloadFileFailReason failReason) {
                    String url = null;
                    if (downloadFileInfo != null) {
                        url = downloadFileInfo.getUrl();
                    }
                    String type = null;
                    if (failReason != null) {
                        type = failReason.getType();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run onMoveDownloadFileFailed,\u79fb\u52a8\u5931\u8d25\uff0cmoveCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedMove.size():" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0curl\uff1a" + url + "," + "failReason:" + type));
                    MoveDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
                    if (this.deleteCount == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() - MoveDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"MoveDownloadFilesTask.run onMoveDownloadFileFailed,\u79fb\u52a8\u5931\u8d25\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                        MoveDownloadFilesTask.this.onMoveDownloadFilesCompleted();
                    }
                }
            };
            for (int i = 0; i < this.mDownloadFilesNeedMove.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedMove.get(i);
                if (downloadFileInfo == null) continue;
                String url = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d((String)TAG, (String)"MoveDownloadFilesTask.run task has been sopped,\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u79fb\u52a8\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                    this.onMoveDownloadFilesCompleted();
                    continue;
                }
                DownloadMoveManager.this.move(url, this.mNewDirPath, onMoveDownloadFileListener, true);
            }
        }

        private void onMoveDownloadFilesCompleted() {
            if (this.mCompleted) {
                return;
            }
            if (this.mOnMoveDownloadFilesListener != null) {
                OnMoveDownloadFilesListener.MainThreadHelper.onMoveDownloadFilesCompleted(this.mDownloadFilesNeedMove, this.mDownloadFilesMoved, this.mOnMoveDownloadFilesListener);
            }
            this.mCompleted = true;
            this.mIsStop = true;
        }
    }
}

