/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.io.File;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.util.FileUtil;

public class MoveDownloadFileTask
implements Runnable {
    private static final String TAG = MoveDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private String mNewDirPath;
    private DownloadFileCacher mFileDownloadCacher;
    private OnMoveDownloadFileListener mOnMoveDownloadFileListener;

    public MoveDownloadFileTask(String url, String newDirPath, DownloadFileCacher fileDownloadCacher) {
        this.mUrl = url;
        this.mNewDirPath = newDirPath;
        this.mFileDownloadCacher = fileDownloadCacher;
    }

    public void setOnMoveDownloadFileListener(OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.mOnMoveDownloadFileListener = onMoveDownloadFileListener;
    }

    @Override
    public void run() {
        DownloadFileInfo downloadFileInfo = this.mFileDownloadCacher.getDownloadFile(this.mUrl);
        if (downloadFileInfo == null) {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the DownloadFile is empty!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_NULL_POINTER), this.mOnMoveDownloadFileListener);
            return;
        }
        OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFilePrepared(downloadFileInfo, this.mOnMoveDownloadFileListener);
        File oldFile = null;
        File newFile = null;
        switch (downloadFileInfo.getStatus()) {
            case 5: {
                oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getFileName());
                newFile = new File(this.mNewDirPath, downloadFileInfo.getFileName());
                break;
            }
            case 6: {
                oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                newFile = new File(this.mNewDirPath, downloadFileInfo.getTempFileName());
                break;
            }
            default: {
                OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("DownloadFile status error!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_FILE_STATUS_ERROR), this.mOnMoveDownloadFileListener);
                return;
            }
        }
        if (oldFile == null || !oldFile.exists()) {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the original fie does not exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST), this.mOnMoveDownloadFileListener);
            return;
        }
        if (newFile != null && !newFile.getParentFile().exists()) {
            FileUtil.createFileParentDir(newFile.getAbsolutePath());
        }
        if (newFile != null && newFile.exists()) {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the target fie exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_TARGET_FILE_EXIST), this.mOnMoveDownloadFileListener);
            return;
        }
        boolean moveResult = false;
        if (oldFile != null && newFile != null) {
            moveResult = oldFile.renameTo(newFile);
        }
        if (moveResult) {
            downloadFileInfo.setFileDir(this.mNewDirPath);
            moveResult = this.mFileDownloadCacher.updateDownloadFile(downloadFileInfo);
            if (moveResult) {
                OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileSuccess(downloadFileInfo, this.mOnMoveDownloadFileListener);
            } else {
                OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("update record error!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_UPDATE_RECORD_ERROR), this.mOnMoveDownloadFileListener);
            }
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, null, this.mOnMoveDownloadFileListener);
        }
    }
}

