/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpResponseFactory;
import wiremock.org.apache.hc.core5.http.config.Http1Config;
import wiremock.org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import wiremock.org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import wiremock.org.apache.hc.core5.http.message.LineParser;
import wiremock.org.apache.hc.core5.http.message.StatusLine;
import wiremock.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<ClassicHttpResponse> {
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParser(Http1Config http1Config, LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        super(http1Config, lineParser);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Deprecated
    public DefaultHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config http1Config) {
        this(http1Config, lineParser, responseFactory);
    }

    public DefaultHttpResponseParser(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpResponseParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        StatusLine statusline = this.getLineParser().parseStatusLine(buffer);
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(statusline.getStatusCode(), statusline.getReasonPhrase());
        response.setVersion(statusline.getProtocolVersion());
        return response;
    }
}

