/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.AdvancedPathPattern;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.io.IOException;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonSerializer;
import wiremock.com.fasterxml.jackson.databind.SerializerProvider;
import wiremock.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;

public abstract class PathPatternJsonSerializer<T extends PathPattern>
extends JsonSerializer<T> {
    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        this.serializePathPattern(value, gen, serializers);
        gen.writeEndObject();
    }

    protected void serializePathPattern(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (((PathPattern)value).isSimple()) {
            gen.writeStringField(((StringValuePattern)value).getName(), ((StringValuePattern)value).getExpected());
        } else {
            AdvancedPathPattern advancedPathPattern = new AdvancedPathPattern(((StringValuePattern)value).getExpected(), ((PathPattern)value).getValuePattern());
            gen.writeFieldName(((StringValuePattern)value).getName());
            JavaType javaType = serializers.getConfig().constructType(advancedPathPattern.getClass());
            JsonSerializer<Object> serializer = BeanSerializerFactory.instance.createSerializer(serializers, javaType);
            serializer.serialize(advancedPathPattern, gen, serializers);
        }
        this.serializeAdditionalFields(value, gen, serializers);
    }

    protected abstract void serializeAdditionalFields(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

