/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.AbstractLogicalMatcher;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class LogicalOr
extends AbstractLogicalMatcher {
    public LogicalOr(StringValuePattern ... operands) {
        super(operands);
    }

    public LogicalOr(@JsonProperty(value="or") List<StringValuePattern> operands) {
        super(operands);
    }

    @Override
    protected String getOperationName() {
        return "OR";
    }

    public List<StringValuePattern> getOr() {
        return this.operands;
    }

    @Override
    public MatchResult match(String value) {
        final List matchResults = this.operands.stream().map(matcher -> matcher.match(value)).collect(Collectors.toList());
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return matchResults.stream().anyMatch(MatchResult::isExactMatch);
            }

            @Override
            public double getDistance() {
                return matchResults.stream().map(MatchResult::getDistance).sorted().findFirst().get();
            }
        };
    }
}

