/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerUtils;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterV2;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.diff.DiffEventData;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import java.util.List;
import java.util.Map;

public class StubRequestHandler
extends AbstractRequestHandler {
    private final StubServer stubServer;
    private final Admin admin;
    private final Map<String, PostServeAction> postServeActions;
    private final Map<String, ServeEventListener> serveEventListeners;
    private final RequestJournal requestJournal;
    private final boolean loggingDisabled;
    private final NotMatchedRenderer notMatchedRenderer;

    public StubRequestHandler(StubServer stubServer, ResponseRenderer responseRenderer, Admin admin, Map<String, PostServeAction> postServeActions, Map<String, ServeEventListener> serveEventListeners, RequestJournal requestJournal, List<RequestFilter> requestFilters, List<RequestFilterV2> v2RequestFilters, boolean loggingDisabled, DataTruncationSettings dataTruncationSettings, NotMatchedRenderer notMatchedRenderer) {
        super(responseRenderer, requestFilters, v2RequestFilters, dataTruncationSettings);
        this.stubServer = stubServer;
        this.admin = admin;
        this.postServeActions = postServeActions;
        this.serveEventListeners = serveEventListeners;
        this.requestJournal = requestJournal;
        this.loggingDisabled = loggingDisabled;
        this.notMatchedRenderer = notMatchedRenderer;
    }

    @Override
    public ServeEvent handleRequest(ServeEvent initialServeEvent) {
        ServeEventListenerUtils.triggerListeners(this.serveEventListeners, ServeEventListener.RequestPhase.BEFORE_MATCH, initialServeEvent);
        return this.stubServer.serveStubFor(initialServeEvent);
    }

    @Override
    protected boolean logRequests() {
        return !this.loggingDisabled;
    }

    @Override
    protected void beforeResponseSent(ServeEvent serveEvent, Response response) {
        if (!response.wasConfigured()) {
            this.appendNonMatchSubEvent(serveEvent);
        }
        this.requestJournal.requestReceived(serveEvent);
        ServeEventListenerUtils.triggerListeners(this.serveEventListeners, ServeEventListener.RequestPhase.BEFORE_RESPONSE_SENT, serveEvent);
    }

    private void appendNonMatchSubEvent(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = this.notMatchedRenderer.execute(this.admin, serveEvent, PathParams.empty());
        HttpHeaders headers = responseDefinition.getHeaders();
        String contentTypeHeader = headers != null && headers.getHeader("Content-Type").isPresent() ? headers.getContentTypeHeader().firstValue() : null;
        serveEvent.appendSubEvent("REQUEST_NOT_MATCHED", new DiffEventData(responseDefinition.getStatus(), contentTypeHeader, responseDefinition.getBody()));
    }

    @Override
    protected void afterResponseSent(ServeEvent serveEvent, Response response) {
        this.requestJournal.serveCompleted(serveEvent);
        this.triggerPostServeActions(serveEvent);
        ServeEventListenerUtils.triggerListeners(this.serveEventListeners, ServeEventListener.RequestPhase.AFTER_COMPLETE, serveEvent);
    }

    private void triggerPostServeActions(ServeEvent serveEvent) {
        for (PostServeAction postServeAction : this.postServeActions.values()) {
            postServeAction.doGlobalAction(serveEvent, this.admin);
        }
        List<PostServeActionDefinition> postServeActionDefs = serveEvent.getPostServeActions();
        for (PostServeActionDefinition postServeActionDef : postServeActionDefs) {
            PostServeAction action = this.postServeActions.get(postServeActionDef.getName());
            if (action != null) {
                Parameters parameters = postServeActionDef.getParameters();
                action.doAction(serveEvent, this.admin, parameters);
                continue;
            }
            LocalNotifier.notifier().error("No extension was found named \"" + postServeActionDef.getName() + "\"");
        }
    }
}

