/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.DelayDistribution;
import java.util.concurrent.ThreadLocalRandom;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public final class LogNormal
implements DelayDistribution {
    @JsonProperty(value="median")
    private final double median;
    @JsonProperty(value="sigma")
    private final double sigma;
    @JsonProperty(value="maxValue", required=false)
    private final Double maxValue;

    @JsonCreator
    public LogNormal(@JsonProperty(value="median") double median, @JsonProperty(value="sigma") double sigma, @JsonProperty(value="maxValue") Double maxValue) {
        this.median = median;
        this.sigma = sigma;
        this.maxValue = maxValue;
        if (maxValue != null && maxValue < median) {
            throw new IllegalArgumentException(String.format("The max value (%s) has to be greater than or equal to the median (%s). Sigma: %s", maxValue, median, sigma));
        }
    }

    public LogNormal(double median, double sigma) {
        this(median, sigma, null);
    }

    @Override
    public long sampleMillis() {
        long generatedValue = this.generateDelayMillis();
        if (this.maxValue == null) {
            return generatedValue;
        }
        for (int i = 0; (double)generatedValue > this.maxValue && i < 10; ++i) {
            generatedValue = this.generateDelayMillis();
        }
        return Math.round(Math.min(this.maxValue, (double)generatedValue));
    }

    private long generateDelayMillis() {
        return Math.round(Math.exp(ThreadLocalRandom.current().nextGaussian() * this.sigma) * this.median);
    }
}

