/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import wiremock.com.fasterxml.jackson.annotation.JsonValue;
import wiremock.com.fasterxml.jackson.databind.util.ISO8601Utils;

public class RenderableDate
extends Date {
    private static final long DIVIDE_MILLISECONDS_TO_SECONDS = 1000L;
    private final String format;
    private final ZoneId timezone;

    public RenderableDate(Date date, String format, ZoneId timezone) {
        super(date.getTime());
        this.format = format;
        this.timezone = timezone;
    }

    public String getFormat() {
        return this.format;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    @Override
    @JsonValue
    public String toString() {
        if (this.format != null) {
            if (this.format.equals("epoch")) {
                return String.valueOf(this.getTime());
            }
            if (this.format.equals("unix")) {
                return String.valueOf(this.getTime() / 1000L);
            }
            return this.formatCustom();
        }
        return this.timezone != null ? ISO8601Utils.format(this, false, TimeZone.getTimeZone(this.timezone)) : ISO8601Utils.format(this, false);
    }

    private String formatCustom() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.format);
        if (this.timezone != null) {
            TimeZone zone = TimeZone.getTimeZone(this.timezone);
            dateFormat.setTimeZone(zone);
        }
        return dateFormat.format(this);
    }
}

