/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.RequestCache;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Template;

public class HandlebarsOptimizedTemplate {
    private final Template template;
    private String startContent;
    private String templateContent;
    private String endContent;

    public HandlebarsOptimizedTemplate(Handlebars handlebars, String content) {
        int lastDelimEndPosition;
        this.startContent = content;
        this.templateContent = "";
        this.endContent = "";
        int firstDelimStartPosition = content.indexOf("{{");
        if (firstDelimStartPosition != -1 && (lastDelimEndPosition = content.lastIndexOf("}}")) != -1) {
            this.startContent = content.substring(0, firstDelimStartPosition);
            this.templateContent = content.substring(firstDelimStartPosition, lastDelimEndPosition + "}}".length());
            this.endContent = content.substring(lastDelimEndPosition + "}}".length());
        }
        this.template = HandlebarsOptimizedTemplate.uncheckedCompileTemplate(handlebars, this.templateContent);
    }

    private static Template uncheckedCompileTemplate(Handlebars handlebars, String templateContent) {
        try {
            return handlebars.compileInline(templateContent);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Template.class);
        }
    }

    public String apply(Object contextData) {
        RequestCache requestCache = RequestCache.getCurrent();
        Context context = Context.newBuilder(contextData).combine("requestCache", requestCache).build();
        return this.startContent + this.applyTemplate(context) + this.endContent;
    }

    private String applyTemplate(Context context) {
        return Exceptions.uncheck(() -> {
            StringWriter stringWriter = new StringWriter(this.template.text().length() * 2);
            this.template.apply(context, (Writer)stringWriter);
            return ((Object)stringWriter).toString();
        }, String.class);
    }
}

