/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class WireMockHttpServletMultipartAdapter
implements Request.Part {
    private final Part mPart;
    private final HttpHeaders headers;

    public WireMockHttpServletMultipartAdapter(Part servletPart) {
        this.mPart = servletPart;
        List httpHeaders = this.mPart.getHeaderNames().stream().map(name -> {
            Collection headerValues = servletPart.getHeaders(name);
            return HttpHeader.httpHeader((String)name, (String[])headerValues.toArray(new String[headerValues.size()]));
        }).collect(Collectors.toList());
        this.headers = new HttpHeaders(httpHeaders);
    }

    public static WireMockHttpServletMultipartAdapter from(Part servletPart) {
        return new WireMockHttpServletMultipartAdapter(servletPart);
    }

    public String getName() {
        return this.mPart.getName();
    }

    public String getFileName() {
        return this.mPart.getSubmittedFileName();
    }

    public HttpHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Body getBody() {
        try {
            byte[] bytes = this.mPart.getInputStream().readAllBytes();
            HttpHeader header = this.getHeader("Content-Type");
            ContentTypeHeader contentTypeHeader = header.isPresent() ? new ContentTypeHeader(header.firstValue()) : ContentTypeHeader.absent();
            return Body.ofBinaryOrText((byte[])bytes, (ContentTypeHeader)contentTypeHeader);
        }
        catch (IOException e) {
            return (Body)Exceptions.throwUnchecked((Throwable)e, Body.class);
        }
    }
}

