/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.diff.DiffEventData;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class NotMatchedServlet
extends HttpServlet {
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional.ofNullable(req.getAttribute("wiremock.ORIGINAL_SERVE_EVENT")).map(ServeEvent.class::cast).flatMap(ServeEvent::getDiffSubEvent).ifPresentOrElse(diffSubEvent -> {
            DiffEventData diffData = (DiffEventData)diffSubEvent.getDataAs(DiffEventData.class);
            resp.setStatus(diffData.getStatus());
            resp.setContentType(diffData.getContentType());
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            try (PrintWriter writer = resp.getWriter();){
                writer.write(diffData.getReport());
                writer.flush();
            }
            catch (IOException e) {
                Exceptions.throwUnchecked((Throwable)e);
            }
        }, () -> Exceptions.uncheck(() -> resp.sendError(404)));
    }
}

