/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.client.apache5;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Version;
import com.github.tomakehurst.wiremock.http.client.apache5.NetworkAddressRulesAdheringDnsResolver;
import com.github.tomakehurst.wiremock.http.client.apache5.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSpecificHostsStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustStrategy;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class StaticApacheHttpClientFactory {
    StaticApacheHttpClientFactory() {
    }

    static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse, String userAgent) {
        NetworkAddressRulesAdheringDnsResolver dnsResolver = new NetworkAddressRulesAdheringDnsResolver(networkAddressRules);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)timeoutMilliseconds)).setProtocolUpgradeEnabled(false).build());
        Object effectiveUserAgent = userAgent != null ? userAgent : "WireMock " + Version.getCurrentVersion();
        builder.setUserAgent((String)effectiveUserAgent);
        if (disableConnectionReuse) {
            builder.setConnectionReuseStrategy((request, response, context) -> false).setKeepAliveStrategy((response, context) -> TimeValue.ZERO_MILLISECONDS);
        }
        if (useSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (Strings.isNotEmpty((String)proxySettings.getUsername()) && Strings.isNotEmpty((String)proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), (Credentials)new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword().toCharArray()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        SSLContext sslContext = StaticApacheHttpClientFactory.buildSslContext(trustStoreSettings, trustAllCertificates, trustedHosts);
        LayeredConnectionSocketFactory sslSocketFactory = StaticApacheHttpClientFactory.buildSslConnectionSocketFactory(sslContext);
        builder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDnsResolver((DnsResolver)dnsResolver).setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).setValidateAfterInactivity(TimeValue.ofSeconds((long)5L)).setConnectionFactory((HttpConnectionFactory)new ManagedHttpClientConnectionFactory(null, CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build(), null)).build());
        return builder.build();
    }

    private static LayeredConnectionSocketFactory buildSslConnectionSocketFactory(SSLContext sslContext) {
        String[] supportedProtocols = StaticApacheHttpClientFactory.split(System.getProperty("https.protocols"));
        String[] supportedCipherSuites = StaticApacheHttpClientFactory.split(System.getProperty("https.cipherSuites"));
        return new SSLConnectionSocketFactory((SSLSocketFactory)new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), supportedProtocols, supportedCipherSuites, (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static SSLContext buildSslContext(KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts) {
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            return StaticApacheHttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings, trustAllCertificates, trustedHosts);
        }
        if (trustAllCertificates) {
            return StaticApacheHttpClientFactory.buildAllowAnythingSSLContext();
        }
        try {
            return SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSpecificHostsStrategy(trustedHosts)).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return (SSLContext)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray());
            if (trustSelfSignedCertificates) {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            } else if (StaticApacheHttpClientFactory.containsCertificate(trustStore)) {
                sslContextBuilder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSpecificHostsStrategy(trustedHosts));
            } else {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSpecificHostsStrategy(trustedHosts));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked((Throwable)e, SSLContext.class);
        }
    }

    private static boolean containsCertificate(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                if (!(trustStore.getEntry(alias, null) instanceof KeyStore.TrustedCertificateEntry)) continue;
                return true;
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            }
        }
        return false;
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustEverythingStrategy()).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }
}

