/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.ProhibitedNetworkAddressException;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ImmutableRequest;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private final HttpClient reverseProxyClient;
    private final HttpClient forwardProxyClient;
    private final boolean preserveHostHeader;
    private final String hostHeaderValue;
    private final SettingsStore settingsStore;
    private final boolean stubCorsEnabled;
    private final Set<String> supportedEncodings;
    private static final Predicate<String> absoluteUrlMatcher = Pattern.compile("^https?://[a-zA-Z0-9]", 2).asPredicate();

    public ProxyResponseRenderer(boolean preserveHostHeader, String hostHeaderValue, SettingsStore settingsStore, boolean stubCorsEnabled, HttpClient reverseProxyClient, HttpClient forwardProxyClient) {
        this(preserveHostHeader, hostHeaderValue, settingsStore, stubCorsEnabled, null, reverseProxyClient, forwardProxyClient);
    }

    public ProxyResponseRenderer(boolean preserveHostHeader, String hostHeaderValue, SettingsStore settingsStore, boolean stubCorsEnabled, Set<String> supportedEncodings, HttpClient reverseProxyClient, HttpClient forwardProxyClient) {
        this.settingsStore = settingsStore;
        this.preserveHostHeader = preserveHostHeader;
        this.hostHeaderValue = hostHeaderValue;
        this.stubCorsEnabled = stubCorsEnabled;
        this.supportedEncodings = supportedEncodings;
        this.forwardProxyClient = forwardProxyClient;
        this.reverseProxyClient = reverseProxyClient;
    }

    @Override
    public Response render(ServeEvent serveEvent) {
        boolean originalRequestBodyExists;
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        String proxyUrl = responseDefinition.getProxyUrl();
        if (proxyUrl == null || !absoluteUrlMatcher.test(proxyUrl)) {
            return Response.response().status(500).headers(new HttpHeaders(new HttpHeader("Content-Type", "text/plain"))).body("The target proxy address `" + proxyUrl + "` is not an absolute URL.").build();
        }
        ImmutableRequest.Builder requestBuilder = ImmutableRequest.create().withAbsoluteUrl(proxyUrl).withMethod(responseDefinition.getOriginalRequest().getMethod());
        this.addRequestHeaders(requestBuilder, responseDefinition);
        GlobalSettings settings = this.settingsStore.get();
        Request originalRequest = responseDefinition.getOriginalRequest();
        boolean bl = originalRequestBodyExists = originalRequest.getBody() != null && originalRequest.getBody().length > 0;
        if (originalRequestBodyExists || originalRequest.containsHeader("content-length")) {
            requestBuilder.withBody(originalRequest.getBody());
        }
        ImmutableRequest request = requestBuilder.build();
        HttpClient client = this.chooseClient(serveEvent.getRequest().isBrowserProxyRequest());
        try {
            Response httpResponse = client.execute(request);
            return Response.Builder.like(httpResponse).fromProxy(true).headers(this.headersFrom(httpResponse, responseDefinition)).configureDelay(settings.getFixedDelay(), settings.getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay()).build();
        }
        catch (ProhibitedNetworkAddressException e) {
            return Response.response().status(500).headers(new HttpHeaders(new HttpHeader("Content-Type", "text/plain"))).body("The target proxy address is denied in WireMock's configuration.").build();
        }
        catch (SSLException e) {
            return this.proxyResponseError("SSL", request, e);
        }
        catch (IOException e) {
            return this.proxyResponseError("Network", request, e);
        }
    }

    private Response proxyResponseError(String type, Request request, Exception e) {
        return Response.response().status(500).body(type + " failure trying to make a proxied request from WireMock to " + request.getAbsoluteUrl() + "\r\n" + e.getMessage()).build();
    }

    private HttpClient chooseClient(boolean browserProxyRequest) {
        if (browserProxyRequest) {
            return this.forwardProxyClient;
        }
        return this.reverseProxyClient;
    }

    private HttpHeaders headersFrom(Response response, ResponseDefinition responseDefinition) {
        LinkedList<HttpHeader> httpHeaders = new LinkedList<HttpHeader>();
        for (HttpHeader header : response.getHeaders().all()) {
            if (!this.responseHeaderShouldBeTransferred(header.getKey())) continue;
            httpHeaders.add(header);
        }
        if (responseDefinition.getHeaders() != null) {
            httpHeaders.addAll(responseDefinition.getHeaders().all());
        }
        return new HttpHeaders(httpHeaders);
    }

    private void addRequestHeaders(ImmutableRequest.Builder requestBuilder, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        List removeProxyRequestHeaders = response.getRemoveProxyRequestHeaders() == null ? Collections.emptyList() : response.getRemoveProxyRequestHeaders().stream().map(String::toLowerCase).toList();
        block8: for (String key : originalRequest.getAllHeaderKeys()) {
            String lowerCaseKey = key.toLowerCase();
            if (removeProxyRequestHeaders.contains(lowerCaseKey)) continue;
            switch (lowerCaseKey) {
                case "host": {
                    this.addHostHeader(requestBuilder, response, key, originalRequest);
                    continue block8;
                }
                case "accept-encoding": {
                    this.addAcceptEncodingHeader(requestBuilder, key, originalRequest);
                    continue block8;
                }
            }
            ProxyResponseRenderer.copyHeader(requestBuilder, key, originalRequest);
        }
        if (response.getAdditionalProxyRequestHeaders() != null) {
            for (String key : response.getAdditionalProxyRequestHeaders().keys()) {
                requestBuilder.withHeader(key, response.getAdditionalProxyRequestHeaders().getHeader(key).firstValue());
            }
        }
    }

    private void addHostHeader(ImmutableRequest.Builder requestBuilder, ResponseDefinition response, String key, Request originalRequest) {
        if (this.preserveHostHeader) {
            ProxyResponseRenderer.copyHeader(requestBuilder, key, originalRequest);
        } else if (this.hostHeaderValue != null) {
            requestBuilder.withHeader(key, this.hostHeaderValue);
        } else if (response.getProxyBaseUrl() != null) {
            requestBuilder.withHeader(key, URI.create(response.getProxyBaseUrl()).getAuthority());
        }
    }

    private void addAcceptEncodingHeader(ImmutableRequest.Builder requestBuilder, String key, Request originalRequest) {
        if (this.supportedEncodings == null) {
            ProxyResponseRenderer.copyHeader(requestBuilder, key, originalRequest);
        } else {
            List prunedAcceptEncodings = originalRequest.header(key).values().stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).filter(this.supportedEncodings::contains).collect(Collectors.toList());
            if (!prunedAcceptEncodings.isEmpty()) {
                requestBuilder.withHeader(key, String.join((CharSequence)",", prunedAcceptEncodings));
            }
        }
    }

    private static void copyHeader(ImmutableRequest.Builder requestBuilder, String key, Request originalRequest) {
        List<String> values = originalRequest.header(key).values();
        requestBuilder.withHeader(key, values);
    }

    public boolean responseHeaderShouldBeTransferred(String key) {
        String lowerCaseKey = key.toLowerCase();
        return !HttpClient.FORBIDDEN_RESPONSE_HEADERS.contains(lowerCaseKey) && (!this.stubCorsEnabled || !lowerCaseKey.startsWith("access-control"));
    }
}

