/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.input;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import wiremock.org.xmlunit.transform.Transformation;

public final class CommentLessSource
extends DOMSource {
    private static final String DEFAULT_VERSION = "2.0";
    private static final String STYLE_TEMPLATE = "<stylesheet version=\"%1$s\" xmlns=\"http://www.w3.org/1999/XSL/Transform\"><template match=\"node()[not(self::comment())]|@*\"><copy><apply-templates select=\"node()[not(self::comment())]|@*\"/></copy></template></stylesheet>";
    public static final String STYLE = CommentLessSource.getStylesheetContent("2.0");

    public CommentLessSource(Source originalSource) {
        this(originalSource, DEFAULT_VERSION);
    }

    public CommentLessSource(Source originalSource, String xsltVersion) {
        if (originalSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        if (xsltVersion == null) {
            throw new IllegalArgumentException("xsltVersion must not be null");
        }
        Transformation t2 = new Transformation(originalSource);
        t2.setStylesheet(CommentLessSource.getStylesheet(xsltVersion));
        this.setNode(t2.transformToDocument());
    }

    private static Source getStylesheet(String xsltVersion) {
        return new StreamSource(new StringReader(CommentLessSource.getStylesheetContentCached(xsltVersion)));
    }

    private static String getStylesheetContentCached(String xsltVersion) {
        return DEFAULT_VERSION.equals(xsltVersion) ? STYLE : CommentLessSource.getStylesheetContent(xsltVersion);
    }

    private static String getStylesheetContent(String xsltVersion) {
        return String.format(STYLE_TEMPLATE, xsltVersion);
    }
}

