/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.hamcrest.collection;

import java.util.Arrays;
import wiremock.org.hamcrest.Description;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.TypeSafeMatcher;

public class IsArray<T>
extends TypeSafeMatcher<T[]> {
    private final Matcher<? super T>[] elementMatchers;

    public IsArray(Matcher<? super T>[] elementMatchers) {
        this.elementMatchers = (Matcher[])elementMatchers.clone();
    }

    @Override
    public boolean matchesSafely(T[] array) {
        if (array.length != this.elementMatchers.length) {
            return false;
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (this.elementMatchers[i2].matches(array[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void describeMismatchSafely(T[] actual, Description mismatchDescription) {
        if (actual.length != this.elementMatchers.length) {
            mismatchDescription.appendText("array length was ").appendValue(actual.length);
            return;
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            if (this.elementMatchers[i2].matches(actual[i2])) continue;
            mismatchDescription.appendText("element ").appendValue(i2).appendText(" ");
            this.elementMatchers[i2].describeMismatch(actual[i2], mismatchDescription);
            return;
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendList(this.descriptionStart(), this.descriptionSeparator(), this.descriptionEnd(), Arrays.asList(this.elementMatchers));
    }

    protected String descriptionStart() {
        return "[";
    }

    protected String descriptionSeparator() {
        return ", ";
    }

    protected String descriptionEnd() {
        return "]";
    }

    public static <T> IsArray<T> array(Matcher<? super T> ... elementMatchers) {
        return new IsArray<T>(elementMatchers);
    }
}

