/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;

public abstract class PatternMatcher {
    public abstract void matched(URI var1) throws Exception;

    public void match(String pattern, URI[] uris, boolean isNullInclusive) throws Exception {
        Pattern p = pattern == null ? null : Pattern.compile(pattern);
        this.match(p, uris, isNullInclusive);
    }

    public void match(Pattern pattern, URI[] uris, boolean isNullInclusive) throws Exception {
        if (uris != null) {
            String[] patterns = pattern == null ? null : pattern.pattern().split(",");
            ArrayList<Pattern> subPatterns = new ArrayList<Pattern>();
            for (int i2 = 0; patterns != null && i2 < patterns.length; ++i2) {
                subPatterns.add(Pattern.compile(patterns[i2]));
            }
            if (subPatterns.isEmpty()) {
                subPatterns.add(pattern);
            }
            if (subPatterns.isEmpty()) {
                this.matchPatterns(null, uris, isNullInclusive);
            } else {
                for (Pattern p : subPatterns) {
                    this.matchPatterns(p, uris, isNullInclusive);
                }
            }
        }
    }

    public void matchPatterns(Pattern pattern, URI[] uris, boolean isNullInclusive) throws Exception {
        for (int i2 = 0; i2 < uris.length; ++i2) {
            URI uri = uris[i2];
            String s2 = uri.toString();
            if ((pattern != null || !isNullInclusive) && (pattern == null || !pattern.matcher(s2).matches())) continue;
            this.matched(uris[i2]);
        }
    }
}

