/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpStatus;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.http.QuotedQualityCSV;
import wiremock.org.eclipse.jetty.io.ByteBufferOutputStream;
import wiremock.org.eclipse.jetty.server.Dispatcher;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.handler.AbstractHandler;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.QuotedStringTokenizer;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "wiremock.org.eclipse.jetty.server.error_page";
    public static final String ERROR_CONTEXT = "wiremock.org.eclipse.jetty.server.error_context";
    public static final String ERROR_CHARSET = "wiremock.org.eclipse.jetty.server.error_charset";
    boolean _showServlet = true;
    boolean _showStacks = true;
    boolean _disableStacks = false;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    public boolean errorPageForMethod(String method) {
        switch (method) {
            case "GET": 
            case "POST": 
            case "HEAD": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
        block11: {
            String cacheControl = this.getCacheControl();
            if (cacheControl != null) {
                response.setHeader(HttpHeader.CACHE_CONTROL.asString(), cacheControl);
            }
            String errorPage = this instanceof ErrorPageMapper ? ((ErrorPageMapper)((Object)this)).getErrorPage(request2) : null;
            ContextHandler.Context context = baseRequest.getErrorContext();
            Dispatcher errorDispatcher = errorPage != null && context != null ? (Dispatcher)context.getRequestDispatcher(errorPage) : null;
            try {
                String message;
                block10: {
                    if (errorDispatcher != null) {
                        try {
                            errorDispatcher.error(request2, response);
                            return;
                        }
                        catch (ServletException e) {
                            LOG.debug("Unable to call error dispatcher", e);
                            if (!response.isCommitted()) break block10;
                            baseRequest.setHandled(true);
                            return;
                        }
                    }
                }
                if ((message = (String)request2.getAttribute("wiremock.jakarta.servlet.error.message")) == null) {
                    message = baseRequest.getResponse().getReason();
                }
                this.generateAcceptableResponse(baseRequest, request2, response, response.getStatus(), message);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                baseRequest.setHandled(true);
            }
        }
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request2, HttpServletResponse response, int code, String message) throws IOException {
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT, QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        if (acceptable.isEmpty() && !baseRequest.getHttpFields().contains(HttpHeader.ACCEPT)) {
            this.generateAcceptableResponse(baseRequest, request2, response, code, message, MimeTypes.Type.TEXT_HTML.asString());
        } else {
            for (String mimeType : acceptable) {
                this.generateAcceptableResponse(baseRequest, request2, response, code, message, mimeType);
                if (!response.isCommitted() && !baseRequest.getResponse().isWritingOrStreaming()) continue;
                break;
            }
        }
    }

    @Deprecated
    protected Writer getAcceptableWriter(Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException {
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (acceptable.isEmpty()) {
            response.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
            return response.getWriter();
        }
        for (String charset : acceptable) {
            try {
                if ("*".equals(charset)) {
                    response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                } else {
                    response.setCharacterEncoding(Charset.forName(charset).name());
                }
                return response.getWriter();
            }
            catch (Exception e) {
                LOG.trace("IGNORED", e);
            }
        }
        return null;
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request2, HttpServletResponse response, int code, String message, String contentType) throws IOException {
        MimeTypes.Type type;
        Charset charset = null;
        List<String> acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT_CHARSET);
        if (!acceptable.isEmpty()) {
            for (String name : acceptable) {
                if ("*".equals(name)) {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                try {
                    charset = Charset.forName(name);
                }
                catch (Exception e) {
                    LOG.trace("IGNORED", e);
                }
            }
            if (charset == null) {
                return;
            }
        }
        switch (contentType) {
            case "text/html": 
            case "text/*": 
            case "*/*": {
                type = MimeTypes.Type.TEXT_HTML;
                if (charset != null) break;
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            case "text/json": 
            case "application/json": {
                type = MimeTypes.Type.TEXT_JSON;
                if (charset != null) break;
                charset = StandardCharsets.UTF_8;
                break;
            }
            case "text/plain": {
                type = MimeTypes.Type.TEXT_PLAIN;
                if (charset != null) break;
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            default: {
                return;
            }
        }
        while (true) {
            try {
                ByteBuffer buffer = baseRequest.getResponse().getHttpOutput().getBuffer();
                ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, charset));
                switch (type) {
                    case TEXT_HTML: {
                        response.setContentType(MimeTypes.Type.TEXT_HTML.asString());
                        response.setCharacterEncoding(charset.name());
                        request2.setAttribute(ERROR_CHARSET, charset);
                        this.handleErrorPage(request2, writer, code, message);
                        break;
                    }
                    case TEXT_JSON: {
                        response.setContentType(contentType);
                        this.writeErrorJson(request2, writer, code, message);
                        break;
                    }
                    case TEXT_PLAIN: {
                        response.setContentType(MimeTypes.Type.TEXT_PLAIN.asString());
                        response.setCharacterEncoding(charset.name());
                        this.writeErrorPlain(request2, writer, code, message);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                writer.flush();
            }
            catch (BufferOverflowException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Error page too large: {} {} {}", code, message, request2, e);
                } else {
                    LOG.warn("Error page too large: {} {} {}", code, message, request2);
                }
                baseRequest.getResponse().resetContent();
                if (this._disableStacks) break;
                LOG.info("Disabling showsStacks for {}", (Object)this);
                this._disableStacks = true;
                continue;
            }
            break;
        }
        baseRequest.getHttpChannel().sendResponseAndComplete();
    }

    protected void handleErrorPage(HttpServletRequest request2, Writer writer, int code, String message) throws IOException {
        this.writeErrorPage(request2, writer, code, message, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest request2, Writer writer, int code, String message, boolean showStacks) throws IOException {
        if (message == null) {
            message = HttpStatus.getMessage(code);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(request2, writer, code, message);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody(request2, writer, code, message, showStacks);
        writer.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest request2, Writer writer, int code, String message) throws IOException {
        Charset charset = (Charset)request2.getAttribute(ERROR_CHARSET);
        if (charset != null) {
            writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=");
            writer.write(charset.name());
            writer.write("\"/>\n");
        }
        writer.write("<title>Error ");
        String status = Integer.toString(code);
        writer.write(status);
        if (message != null && !message.equals(status)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString(message));
        }
        writer.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest request2, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String uri = request2.getRequestURI();
        this.writeErrorPageMessage(request2, writer, code, message, uri);
        if (showStacks && !this._disableStacks) {
            this.writeErrorPageStacks(request2, writer);
        }
        Request.getBaseRequest(request2).getHttpChannel().getHttpConfiguration().writePoweredBy(writer, "<hr/>", "<hr/>\n");
    }

    protected void writeErrorPageMessage(HttpServletRequest request2, Writer writer, int code, String message, String uri) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        String status = Integer.toString(code);
        writer.write(status);
        if (message != null && !message.equals(status)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString(message));
        }
        writer.write("</h2>\n");
        writer.write("<table>\n");
        this.htmlRow(writer, "URI", uri);
        this.htmlRow(writer, "STATUS", status);
        this.htmlRow(writer, "MESSAGE", message);
        if (this.isShowServlet()) {
            this.htmlRow(writer, "SERVLET", request2.getAttribute("wiremock.jakarta.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request2.getAttribute("wiremock.jakarta.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            this.htmlRow(writer, "CAUSED BY", cause);
        }
        writer.write("</table>\n");
    }

    private void htmlRow(Writer writer, String tag, Object value) throws IOException {
        writer.write("<tr><th>");
        writer.write(tag);
        writer.write(":</th><td>");
        if (value == null) {
            writer.write("-");
        } else {
            writer.write(StringUtil.sanitizeXmlString(value.toString()));
        }
        writer.write("</td></tr>\n");
    }

    private void writeErrorPlain(HttpServletRequest request2, PrintWriter writer, int code, String message) {
        writer.write("HTTP ERROR ");
        writer.write(Integer.toString(code));
        writer.write(32);
        writer.write(StringUtil.sanitizeXmlString(message));
        writer.write("\n");
        writer.printf("URI: %s%n", request2.getRequestURI());
        writer.printf("STATUS: %s%n", code);
        writer.printf("MESSAGE: %s%n", message);
        if (this.isShowServlet()) {
            writer.printf("SERVLET: %s%n", request2.getAttribute("wiremock.jakarta.servlet.error.servlet_name"));
        }
        for (Throwable cause = (Throwable)request2.getAttribute("wiremock.jakarta.servlet.error.exception"); cause != null; cause = cause.getCause()) {
            writer.printf("CAUSED BY %s%n", cause);
            if (!this.isShowStacks() || this._disableStacks) continue;
            cause.printStackTrace(writer);
        }
    }

    private void writeErrorJson(HttpServletRequest request2, PrintWriter writer, int code, String message) {
        Throwable cause = (Throwable)request2.getAttribute("wiremock.jakarta.servlet.error.exception");
        Object servlet = request2.getAttribute("wiremock.jakarta.servlet.error.servlet_name");
        HashMap<Object, String> json = new HashMap<Object, String>();
        json.put("url", request2.getRequestURI());
        json.put("status", Integer.toString(code));
        json.put("message", message);
        if (this.isShowServlet() && servlet != null) {
            json.put("servlet", servlet.toString());
        }
        int c = 0;
        while (cause != null) {
            json.put("cause" + c++, cause.toString());
            cause = cause.getCause();
        }
        writer.append(json.entrySet().stream().map(e -> QuotedStringTokenizer.quote((String)e.getKey()) + ":" + QuotedStringTokenizer.quote(StringUtil.sanitizeXmlString((String)e.getValue()))).collect(Collectors.joining(",\n", "{\n", "\n}")));
    }

    protected void writeErrorPageStacks(HttpServletRequest request2, Writer writer) throws IOException {
        Throwable th = (Throwable)request2.getAttribute("wiremock.jakarta.servlet.error.exception");
        if (th != null) {
            writer.write("<h3>Caused by:</h3><pre>");
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
                pw.flush();
                this.write(writer, sw.getBuffer().toString());
            }
            writer.write("</pre>\n");
        }
    }

    public ByteBuffer badMessageError(int status, String reason, HttpFields.Mutable fields) {
        if (reason == null) {
            reason = HttpStatus.getMessage(status);
        }
        if (HttpStatus.hasNoBody(status)) {
            return BufferUtil.EMPTY_BUFFER;
        }
        fields.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML_8859_1.asString());
        return BufferUtil.toBuffer("<h1>Bad Message " + status + "</h1><pre>reason: " + reason + "</pre>");
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl;
    }

    public boolean isShowServlet() {
        return this._showServlet;
    }

    public void setShowServlet(boolean showServlet) {
        this._showServlet = showServlet;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this._showStacks = showStacks;
    }

    public void setShowMessageInTitle(boolean showMessageInTitle) {
        this._showMessageInTitle = showMessageInTitle;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    protected void write(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        writer.write(StringUtil.sanitizeXmlString(string));
    }

    public static ErrorHandler getErrorHandler(Server server, ContextHandler context) {
        ErrorHandler errorHandler = null;
        if (context != null) {
            errorHandler = context.getErrorHandler();
        }
        if (errorHandler == null && server != null) {
            errorHandler = server.getBean(ErrorHandler.class);
        }
        return errorHandler;
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

