/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.io.IOException;
import wiremock.jakarta.servlet.AsyncContext;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.handler.HandlerWrapper;

public class AsyncDelayHandler
extends HandlerWrapper {
    public static final String AHW_ATTR = "o.e.j.s.h.AsyncHandlerWrapper";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
        if (!this.isStarted() || this._handler == null) {
            return;
        }
        DispatcherType ctype = baseRequest.getDispatcherType();
        DispatcherType dtype = (DispatcherType)((Object)baseRequest.getAttribute(AHW_ATTR));
        Object asyncContextPath = null;
        Object asyncPathInfo = null;
        Object asyncQueryString = null;
        Object asyncRequestUri = null;
        Object asyncServletPath = null;
        Object asyncHttpServletMapping = null;
        boolean restart = false;
        if (dtype != null) {
            baseRequest.setAttribute(AHW_ATTR, null);
            baseRequest.setDispatcherType(dtype);
            restart = true;
            asyncContextPath = baseRequest.getAttribute("wiremock.jakarta.servlet.async.context_path");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.context_path", null);
            asyncPathInfo = baseRequest.getAttribute("wiremock.jakarta.servlet.async.path_info");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.path_info", null);
            asyncQueryString = baseRequest.getAttribute("wiremock.jakarta.servlet.async.query_string");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.query_string", null);
            asyncRequestUri = baseRequest.getAttribute("wiremock.jakarta.servlet.async.request_uri");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.request_uri", null);
            asyncServletPath = baseRequest.getAttribute("wiremock.jakarta.servlet.async.servlet_path");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.servlet_path", null);
            asyncHttpServletMapping = baseRequest.getAttribute("wiremock.jakarta.servlet.async.mapping");
            baseRequest.setAttribute("wiremock.jakarta.servlet.async.mapping", null);
        }
        if (!this.startHandling(baseRequest, restart)) {
            AsyncContext context = baseRequest.startAsync();
            baseRequest.setAttribute(AHW_ATTR, (Object)ctype);
            this.delayHandling(baseRequest, context);
            return;
        }
        try {
            this._handler.handle(target, baseRequest, request2, response);
            if (restart) {
                baseRequest.setDispatcherType(ctype);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.context_path", asyncContextPath);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.path_info", asyncPathInfo);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.query_string", asyncQueryString);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.request_uri", asyncRequestUri);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.servlet_path", asyncServletPath);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.mapping", asyncHttpServletMapping);
            }
            this.endHandling(baseRequest);
        }
        catch (Throwable throwable) {
            if (restart) {
                baseRequest.setDispatcherType(ctype);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.context_path", asyncContextPath);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.path_info", asyncPathInfo);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.query_string", asyncQueryString);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.request_uri", asyncRequestUri);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.servlet_path", asyncServletPath);
                baseRequest.setAttribute("wiremock.jakarta.servlet.async.mapping", asyncHttpServletMapping);
            }
            this.endHandling(baseRequest);
            throw throwable;
        }
    }

    protected boolean startHandling(Request request2, boolean restart) {
        return true;
    }

    protected void delayHandling(Request request2, AsyncContext context) {
        context.dispatch();
    }

    protected void endHandling(Request request2) {
    }
}

