/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.eclipse.jetty.client.HttpChannel;
import wiremock.org.eclipse.jetty.client.HttpConversation;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.RequestNotifier;
import wiremock.org.eclipse.jetty.client.api.Request;
import wiremock.org.eclipse.jetty.client.api.Result;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpHeaderValue;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public abstract class HttpSender {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSender.class);
    private final ContentConsumer consumer = new ContentConsumer();
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final HttpChannel channel;
    private Request.Content.Subscription subscription;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    public boolean isFailed() {
        return this.requestState.get() == RequestState.FAILURE;
    }

    public void send(HttpExchange exchange2) {
        if (!this.queuedToBegin(exchange2)) {
            return;
        }
        if (!this.beginToHeaders(exchange2)) {
            return;
        }
        this.demand();
    }

    protected boolean expects100Continue(Request request2) {
        return request2.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request2 = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", (Object)request2);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request2);
        Request.Content body2 = request2.getBody();
        this.consumer.exchange = exchange2;
        this.consumer.expect100 = this.expects100Continue(request2);
        this.subscription = body2.subscribe(this.consumer, !this.consumer.expect100);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            return true;
        }
        this.abortRequest(exchange2);
        return false;
    }

    protected boolean beginToHeaders(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request2 = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", request2, System.lineSeparator(), request2.getHeaders().toString().trim());
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request2);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            return true;
        }
        this.abortRequest(exchange2);
        return false;
    }

    protected boolean headersToCommit(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request2 = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", (Object)request2);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request2);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            return true;
        }
        this.abortRequest(exchange2);
        return false;
    }

    protected boolean someToContent(HttpExchange exchange2, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current.ordinal()) {
            case 4: 
            case 5: {
                if (!this.updateRequestState(current, RequestState.TRANSIENT)) {
                    return false;
                }
                HttpRequest request2 = exchange2.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", request2, System.lineSeparator(), BufferUtil.toDetailString(content));
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request2, content);
                if (this.updateRequestState(RequestState.TRANSIENT, RequestState.CONTENT)) {
                    return true;
                }
                this.abortRequest(exchange2);
                return false;
            }
        }
        return false;
    }

    protected boolean someToSuccess(HttpExchange exchange2) {
        RequestState current = this.requestState.get();
        switch (current.ordinal()) {
            case 4: 
            case 5: {
                if (!exchange2.requestComplete(null)) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                HttpRequest request2 = exchange2.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", (Object)request2);
                }
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange2.getRequest());
                Result result = exchange2.terminateRequest();
                this.terminateRequest(exchange2, null, result);
                return true;
            }
        }
        return false;
    }

    private void anyToFailure(Throwable failure) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure {}", (Object)exchange2.getRequest(), (Object)failure);
        }
        if (exchange2.requestComplete(failure)) {
            this.executeAbort(exchange2, failure);
        }
    }

    private void demand() {
        try {
            this.subscription.demand();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failure invoking demand()", x);
            }
            this.anyToFailure(x);
        }
    }

    private void executeAbort(HttpExchange exchange2, Throwable failure) {
        try {
            Executor executor = this.getHttpChannel().getHttpDestination().getHttpClient().getExecutor();
            executor.execute(() -> this.abort(exchange2, failure));
        }
        catch (RejectedExecutionException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange aborted {}", (Object)exchange2, (Object)x);
            }
            this.abort(exchange2, failure);
        }
    }

    private void abortRequest(HttpExchange exchange2) {
        Throwable failure = this.failure.get();
        if (this.subscription != null) {
            this.subscription.fail(failure);
        }
        this.dispose();
        HttpRequest request2 = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request abort {} {} on {}: {}", request2, exchange2, this.getHttpChannel(), failure);
        }
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request2, failure);
        Result result = exchange2.terminateRequest();
        this.terminateRequest(exchange2, failure, result);
    }

    private void terminateRequest(HttpExchange exchange2, Throwable failure, Result result) {
        HttpRequest request2 = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", (Object)request2);
        }
        if (result == null) {
            if (failure != null && exchange2.responseComplete(failure)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {} {}", (Object)request2, (Object)exchange2);
                }
                this.getHttpChannel().abortResponse(exchange2, failure);
            }
        } else {
            result = this.channel.exchangeTerminating(exchange2, result);
            HttpDestination destination = this.getHttpChannel().getHttpDestination();
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", (Object)(failure == null ? "succeeded" : "failed"), (Object)result);
            }
            HttpConversation conversation = exchange2.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, ByteBuffer var2, boolean var3, Callback var4);

    protected abstract void sendContent(HttpExchange var1, ByteBuffer var2, boolean var3, Callback var4);

    protected void reset() {
        this.consumer.reset();
    }

    protected void dispose() {
    }

    public void proceed(HttpExchange exchange2, Throwable failure) {
        this.consumer.expect100 = false;
        if (failure == null) {
            this.demand();
        } else {
            this.anyToFailure(failure);
        }
    }

    public boolean abort(HttpExchange exchange2, Throwable failure) {
        RequestState current;
        this.failure.compareAndSet(null, failure);
        do {
            if ((current = this.requestState.get()) != RequestState.FAILURE) continue;
            return false;
        } while (!this.updateRequestState(current, RequestState.FAILURE));
        boolean abort = current != RequestState.TRANSIENT;
        if (abort) {
            this.abortRequest(exchange2);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers");
        }
        return false;
    }

    private boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    protected String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize {}", (Object)path);
            }
            return path;
        }
    }

    public String toString() {
        return String.format("%s@%x(req=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.failure);
    }

    private class ContentConsumer
    implements Request.Content.Consumer,
    Callback {
        private HttpExchange exchange;
        private boolean expect100;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private Callback callback;
        private boolean committed;

        private ContentConsumer() {
        }

        private void reset() {
            this.exchange = null;
            this.contentBuffer = null;
            this.lastContent = false;
            this.callback = null;
            this.committed = false;
        }

        @Override
        public void onContent(ByteBuffer buffer, boolean last, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content {} last={} for {}", BufferUtil.toDetailString(buffer), last, this.exchange.getRequest());
            }
            this.contentBuffer = buffer.slice();
            this.lastContent = last;
            this.callback = callback;
            if (this.committed) {
                HttpSender.this.sendContent(this.exchange, buffer, last, this);
            } else {
                HttpSender.this.sendHeaders(this.exchange, buffer, last, this);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.failed(failure);
        }

        @Override
        public void succeeded() {
            boolean proceed = false;
            if (this.committed) {
                proceed = HttpSender.this.someToContent(this.exchange, this.contentBuffer);
            } else {
                this.committed = true;
                if (HttpSender.this.headersToCommit(this.exchange)) {
                    proceed = true;
                    if (this.contentBuffer.hasRemaining()) {
                        proceed = HttpSender.this.someToContent(this.exchange, this.contentBuffer);
                    }
                }
            }
            this.callback.succeeded();
            if (!proceed) {
                return;
            }
            if (this.lastContent) {
                HttpSender.this.someToSuccess(this.exchange);
            } else if (this.expect100) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expecting 100 Continue for {}", (Object)this.exchange.getRequest());
                }
            } else {
                HttpSender.this.demand();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.callback != null) {
                this.callback.failed(x);
            }
            HttpSender.this.anyToFailure(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private static enum RequestState {
        TRANSIENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

