/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import wiremock.org.eclipse.jetty.client.HttpChannel;
import wiremock.org.eclipse.jetty.client.HttpClient;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpProxy;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.HttpRequestException;
import wiremock.org.eclipse.jetty.client.IConnection;
import wiremock.org.eclipse.jetty.client.ProxyConfiguration;
import wiremock.org.eclipse.jetty.client.SendFailure;
import wiremock.org.eclipse.jetty.client.api.Authentication;
import wiremock.org.eclipse.jetty.client.api.AuthenticationStore;
import wiremock.org.eclipse.jetty.client.api.Request;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.util.BytesRequestContent;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.io.CyclicTimeouts;
import wiremock.org.eclipse.jetty.util.Attachable;
import wiremock.org.eclipse.jetty.util.HttpCookieStore;
import wiremock.org.eclipse.jetty.util.NanoTime;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;
import wiremock.org.eclipse.jetty.util.thread.Scheduler;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public abstract class HttpConnection
implements IConnection,
Attachable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnection.class);
    private final AutoLock lock = new AutoLock();
    private final HttpDestination destination;
    private final RequestTimeouts requestTimeouts;
    private Object attachment;
    private int idleTimeoutGuard;
    private long idleTimeoutNanoTime;

    protected HttpConnection(HttpDestination destination) {
        this.destination = destination;
        this.requestTimeouts = new RequestTimeouts(destination.getHttpClient().getScheduler());
        this.idleTimeoutNanoTime = NanoTime.now();
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    protected abstract Iterator<HttpChannel> getHttpChannels();

    @Override
    public void send(Request request2, Response.CompleteListener listener) {
        HttpExchange exchange2;
        SendFailure result;
        HttpRequest httpRequest = (HttpRequest)request2;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(httpRequest.getResponseListeners());
        httpRequest.sent();
        if (listener != null) {
            listeners.add(listener);
        }
        if ((result = this.send(exchange2 = new HttpExchange(this.getHttpDestination(), httpRequest, listeners))) != null) {
            httpRequest.abort(result.failure);
        }
    }

    protected SendFailure send(HttpChannel channel, HttpExchange exchange2) {
        boolean send;
        try (AutoLock l = this.lock.lock();){
            boolean bl = send = this.idleTimeoutGuard >= 0;
            if (send) {
                ++this.idleTimeoutGuard;
            }
        }
        if (send) {
            SendFailure result;
            HttpRequest request2 = exchange2.getRequest();
            if (channel.associate(exchange2)) {
                request2.sent();
                this.requestTimeouts.schedule(channel);
                channel.send();
                result = null;
            } else {
                channel.release();
                result = new SendFailure(new HttpRequestException("Could not associate request to connection", request2), false);
            }
            try (AutoLock l = this.lock.lock();){
                --this.idleTimeoutGuard;
                this.idleTimeoutNanoTime = NanoTime.now();
            }
            return result;
        }
        return new SendFailure(new TimeoutException(), true);
    }

    protected void normalizeRequest(HttpRequest request2) {
        URI uri;
        Request.Content content;
        URI uri2;
        boolean normalized = request2.normalized();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalizing {} {}", (Object)(!normalized ? 1 : 0), (Object)request2);
        }
        if (normalized) {
            return;
        }
        String path = request2.getPath();
        if (path.trim().length() == 0) {
            path = "/";
            request2.path(path);
        }
        boolean http1 = request2.getVersion().getVersion() <= 11;
        boolean applyProxyAuthentication = false;
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        if (proxy instanceof HttpProxy) {
            boolean tunnelled = ((HttpProxy)proxy).requiresTunnel(this.destination.getOrigin());
            if (http1 && !tunnelled && (uri2 = request2.getURI()) != null) {
                request2.path(uri2.toString());
            }
            applyProxyAuthentication = !tunnelled;
        }
        HttpFields headers = request2.getHeaders();
        if (http1 && !headers.contains(HttpHeader.HOST.asString())) {
            uri2 = request2.getURI();
            if (uri2 != null) {
                request2.addHeader(new HttpField(HttpHeader.HOST, uri2.getAuthority()));
            } else {
                request2.addHeader(this.getHttpDestination().getHostField());
            }
        }
        if ((content = request2.getBody()) == null) {
            request2.body(new BytesRequestContent(new byte[0][]));
        } else {
            long contentLength;
            if (!headers.contains(HttpHeader.CONTENT_TYPE)) {
                String contentType = content.getContentType();
                if (contentType == null) {
                    contentType = this.getHttpClient().getDefaultRequestContentType();
                }
                if (contentType != null) {
                    HttpField field = new HttpField(HttpHeader.CONTENT_TYPE, contentType);
                    request2.addHeader(field);
                }
            }
            if ((contentLength = content.getLength()) >= 0L && !headers.contains(HttpHeader.CONTENT_LENGTH)) {
                request2.addHeader(new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, contentLength));
            }
        }
        StringBuilder cookies = this.convertCookies(request2.getCookies(), null);
        CookieStore cookieStore = this.getHttpClient().getCookieStore();
        if (cookieStore != null && cookieStore.getClass() != HttpCookieStore.Empty.class && (uri = request2.getURI()) != null) {
            cookies = this.convertCookies(HttpCookieStore.matchPath(uri, cookieStore.get(uri)), cookies);
        }
        if (cookies != null) {
            HttpField cookieField = new HttpField(HttpHeader.COOKIE, cookies.toString());
            request2.addHeader(cookieField);
        }
        if (applyProxyAuthentication) {
            this.applyProxyAuthentication(request2, proxy);
        }
        this.applyRequestAuthentication(request2);
    }

    private StringBuilder convertCookies(List<HttpCookie> cookies, StringBuilder builder) {
        for (HttpCookie cookie : cookies) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append("; ");
            }
            builder.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        return builder;
    }

    private void applyRequestAuthentication(Request request2) {
        Authentication.Result result;
        URI uri;
        AuthenticationStore authenticationStore = this.getHttpClient().getAuthenticationStore();
        if (authenticationStore.hasAuthenticationResults() && (uri = request2.getURI()) != null && (result = authenticationStore.findAuthenticationResult(uri)) != null) {
            result.apply(request2);
        }
    }

    private void applyProxyAuthentication(Request request2, ProxyConfiguration.Proxy proxy) {
        Authentication.Result result;
        if (proxy != null && (result = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(proxy.getURI())) != null) {
            result.apply(request2);
        }
    }

    public boolean onIdleTimeout(long idleTimeout, Throwable failure) {
        try (AutoLock l = this.lock.lock();){
            if (this.idleTimeoutGuard == 0) {
                boolean idle;
                long elapsed = NanoTime.millisSince(this.idleTimeoutNanoTime);
                boolean bl = idle = elapsed > idleTimeout / 2L;
                if (idle) {
                    this.idleTimeoutGuard = -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Idle timeout {}/{}ms - {}", elapsed, idleTimeout, this);
                }
                boolean bl2 = idle;
                return bl2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout skipped - {}", (Object)this);
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    public void destroy() {
        this.requestTimeouts.destroy();
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpChannel> {
        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        protected Iterator<HttpChannel> iterator() {
            return HttpConnection.this.getHttpChannels();
        }

        @Override
        protected boolean onExpired(HttpChannel channel) {
            HttpExchange exchange2 = channel.getHttpExchange();
            if (exchange2 != null) {
                HttpRequest request2 = exchange2.getRequest();
                request2.abort(new TimeoutException("Total timeout " + request2.getConversation().getTimeout() + " ms elapsed"));
            }
            return false;
        }
    }
}

