/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpReceiver;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.HttpSender;
import wiremock.org.eclipse.jetty.client.api.Connection;
import wiremock.org.eclipse.jetty.client.api.Result;
import wiremock.org.eclipse.jetty.io.CyclicTimeouts;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannel.class);
    private final AutoLock _lock = new AutoLock();
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    public boolean associate(HttpExchange exchange2) {
        boolean result = false;
        boolean abort = true;
        try (AutoLock ignored = this._lock.lock();){
            if (this._exchange == null) {
                abort = false;
                result = exchange2.associate(this);
                if (result) {
                    this._exchange = exchange2;
                }
            }
        }
        HttpRequest request2 = exchange2.getRequest();
        if (abort) {
            request2.abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else {
            request2.setConnection(this.getConnection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} associated {} to {}", exchange2, result, this);
            }
        }
        return result;
    }

    public boolean disassociate(HttpExchange exchange2) {
        boolean result = false;
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange2) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", exchange2, result, this);
        }
        return result;
    }

    public HttpExchange getHttpExchange() {
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange httpExchange = this._exchange;
            return httpExchange;
        }
    }

    protected abstract Connection getConnection();

    @Override
    public long getExpireNanoTime() {
        HttpExchange exchange2 = this.getHttpExchange();
        return exchange2 != null ? exchange2.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 != null) {
            this.send(exchange2);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange2, Throwable failure) {
        this.getHttpSender().proceed(exchange2, failure);
    }

    public boolean abort(HttpExchange exchange2, Throwable requestFailure, Throwable responseFailure) {
        boolean requestAborted = false;
        if (requestFailure != null) {
            requestAborted = this.getHttpSender().abort(exchange2, requestFailure);
        }
        boolean responseAborted = false;
        if (responseFailure != null) {
            responseAborted = this.abortResponse(exchange2, responseFailure);
        }
        return requestAborted || responseAborted;
    }

    public boolean abortResponse(HttpExchange exchange2, Throwable failure) {
        return this.getHttpReceiver().abort(exchange2, failure);
    }

    public Result exchangeTerminating(HttpExchange exchange2, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange exchange2, Result result) {
        this.disassociate(exchange2);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

