/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.org.apache.hc.core5.http.HttpVersion;
import wiremock.org.apache.hc.core5.http.Method;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.ProtocolVersion;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.net.URIAuthority;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestTargetHost();

    @Override
    public void process(HttpRequest request2, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        String method = request2.getMethod();
        if (Method.CONNECT.isSame(method) && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request2.containsHeader("Host")) {
            URIAuthority authority = request2.getAuthority();
            if (authority == null) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    return;
                }
                throw new ProtocolException("Target host is unknown");
            }
            if (authority.getUserInfo() != null) {
                authority = new URIAuthority(authority.getHostName(), authority.getPort());
            }
            request2.addHeader("Host", authority);
        }
    }
}

