/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.org.apache.hc.core5.http.HttpVersion;
import wiremock.org.apache.hc.core5.http.Method;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.ProtocolVersion;
import wiremock.org.apache.hc.core5.http.message.MessageSupport;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestContent();
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpRequest request2, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        String method = request2.getMethod();
        if (Method.TRACE.isSame(method) && entity != null) {
            throw new ProtocolException("TRACE request may not enclose an entity");
        }
        if (this.overwrite) {
            request2.removeHeaders("Transfer-Encoding");
            request2.removeHeaders("Content-Length");
        } else {
            if (request2.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (request2.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        if (entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + ver);
                }
                request2.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(request2, entity);
            } else {
                request2.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            MessageSupport.addContentTypeHeader(request2, entity);
            MessageSupport.addContentEncodingHeader(request2, entity);
        }
    }
}

