/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.io.support;

import java.io.IOException;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequestMapper;
import wiremock.org.apache.hc.core5.http.HttpResponseFactory;
import wiremock.org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import wiremock.org.apache.hc.core5.http.io.HttpRequestHandler;
import wiremock.org.apache.hc.core5.http.io.HttpServerRequestHandler;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

public class BasicHttpServerRequestHandler
implements HttpServerRequestHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> handlerMapper) {
        this(handlerMapper, null);
    }

    @Override
    public void handle(ClassicHttpRequest request2, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        HttpRequestHandler handler;
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler httpRequestHandler = handler = this.handlerMapper != null ? this.handlerMapper.resolve(request2, context) : null;
        if (handler != null) {
            handler.handle(request2, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

