/*
 * Decompiled with CFR 0.152.
 */
package wiremock.joptsimple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import wiremock.joptsimple.OptionSpec;
import wiremock.joptsimple.UnrecognizedOptionException;
import wiremock.joptsimple.internal.Messages;
import wiremock.joptsimple.internal.Strings;

public abstract class OptionException
extends RuntimeException {
    private static final long serialVersionUID = -1L;
    private final List<String> options = new ArrayList<String>();

    protected OptionException(List<String> options2) {
        this.options.addAll(options2);
    }

    protected OptionException(Collection<? extends OptionSpec<?>> options2) {
        this.options.addAll(this.specsToStrings(options2));
    }

    protected OptionException(Collection<? extends OptionSpec<?>> options2, Throwable cause) {
        super(cause);
        this.options.addAll(this.specsToStrings(options2));
    }

    private List<String> specsToStrings(Collection<? extends OptionSpec<?>> options2) {
        ArrayList<String> strings = new ArrayList<String>();
        for (OptionSpec<?> each : options2) {
            strings.add(this.specToString(each));
        }
        return strings;
    }

    private String specToString(OptionSpec<?> option) {
        return Strings.join(new ArrayList<String>(option.options()), "/");
    }

    public List<String> options() {
        return Collections.unmodifiableList(this.options);
    }

    protected final String singleOptionString() {
        return this.singleOptionString(this.options.get(0));
    }

    protected final String singleOptionString(String option) {
        return option;
    }

    protected final String multipleOptionString() {
        StringBuilder buffer = new StringBuilder("[");
        LinkedHashSet<String> asSet = new LinkedHashSet<String>(this.options);
        Iterator iter = asSet.iterator();
        while (iter.hasNext()) {
            buffer.append(this.singleOptionString((String)iter.next()));
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    static OptionException unrecognizedOption(String option) {
        return new UnrecognizedOptionException(option);
    }

    @Override
    public final String getMessage() {
        return this.localizedMessage(Locale.getDefault());
    }

    final String localizedMessage(Locale locale) {
        return this.formattedMessage(locale);
    }

    private String formattedMessage(Locale locale) {
        return Messages.message(locale, "wiremock.joptsimple.ExceptionMessages", this.getClass(), "message", this.messageArguments());
    }

    abstract Object[] messageArguments();
}

