/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.TypeValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.SetView;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AnyOfValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas;
    private Boolean canShortCircuit = null;

    public AnyOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), schemaNode.get(i2), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        Set<ValidationMessage> set;
        AnyOfValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
            executionContext.enterDiscriminatorContext(new DiscriminatorContext(), instanceLocation);
        }
        Set<ValidationMessage> allErrors = null;
        int numberOfValidSubSchemas = 0;
        try {
            boolean failFast = executionContext.isFailFast();
            try {
                executionContext.setFailFast(false);
                for (JsonSchema schema : this.schemas) {
                    DiscriminatorContext currentDiscriminatorContext;
                    Set<Object> errors = Collections.emptySet();
                    TypeValidator typeValidator = schema.getTypeValidator();
                    if (typeValidator != null && typeValidator.getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                        if (allErrors == null) {
                            allErrors = new SetView<ValidationMessage>();
                        }
                        ((SetView)allErrors).union(typeValidator.validate(executionContext, node, rootNode, instanceLocation));
                        continue;
                    }
                    errors = !walk ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
                    if (errors.isEmpty()) {
                        ++numberOfValidSubSchemas;
                    }
                    if (errors.isEmpty() && !this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && this.canShortCircuit() && this.canShortCircuit(executionContext)) {
                        allErrors = null;
                        Set<Object> set2 = errors;
                        return set2;
                    }
                    if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && ((currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()).isDiscriminatorMatchFound() || currentDiscriminatorContext.isDiscriminatorIgnore())) {
                        if (!errors.isEmpty()) {
                            if (allErrors == null) {
                                allErrors = new SetView<ValidationMessage>();
                            }
                            ((SetView)allErrors).union(Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(DISCRIMINATOR_REMARK)).build()));
                        } else {
                            allErrors = null;
                        }
                        Set<Object> set3 = errors;
                        return set3;
                    }
                    if (allErrors == null) {
                        allErrors = new SetView<ValidationMessage>();
                    }
                    ((SetView)allErrors).union(errors);
                }
            }
            finally {
                executionContext.setFailFast(failFast);
            }
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && executionContext.getCurrentDiscriminatorContext().isActive() && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorIgnore()) {
                Set<ValidationMessage> set4 = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
                return set4;
            }
        }
        finally {
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
        }
        if (numberOfValidSubSchemas >= 1) {
            return Collections.emptySet();
        }
        if (allErrors != null) {
            set = allErrors;
            return set;
        }
        set = Collections.emptySet();
        return set;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation, true);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return new LinkedHashSet<ValidationMessage>();
    }

    protected boolean canShortCircuit(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isAnnotationCollectionEnabled();
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
        this.canShortCircuit();
    }
}

