/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.util.Objects;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;

public enum ConditionalHelpers implements Helper<Object>
{
    eq{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            Object b = options2.param(0, null);
            boolean result = this.eq(a, b);
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    neq{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            boolean result;
            Object b = options2.param(0, null);
            boolean bl = result = !this.eq(a, b);
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    gt{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options2.param(0, null)) > 0;
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    gte{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options2.param(0, null)) >= 0;
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    lt{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options2.param(0, null)) < 0;
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    lte{

        @Override
        public Object apply(Object a, Options options2) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options2.param(0, null)) <= 0;
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    and{

        @Override
        public Object apply(Object context, Options options2) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (result) {
                for (int i2 = 0; i2 < options2.params.length && result; ++i2) {
                    result = !Handlebars.Utils.isEmpty(options2.params[i2]);
                }
            }
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    or{

        @Override
        public Object apply(Object context, Options options2) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (!result) {
                int i2 = 0;
                while (!result && i2 < options2.params.length) {
                    result = !Handlebars.Utils.isEmpty(options2.params[i2++]);
                }
            }
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    }
    ,
    not{

        @Override
        public Object apply(Object context, Options options2) throws IOException {
            boolean result = Handlebars.Utils.isEmpty(context);
            if (options2.tagType == TagType.SECTION) {
                return result ? options2.fn() : options2.inverse();
            }
            return result ? options2.hash("yes", true) : options2.hash("no", false);
        }
    };


    protected int cmp(Object a, Object b) {
        try {
            Validate.isTrue(a instanceof Comparable, "Not a comparable: " + a, new Object[0]);
            Validate.isTrue(b instanceof Comparable, "Not a comparable: " + b, new Object[0]);
            return ((Comparable)a).compareTo(b);
        }
        catch (ClassCastException x) {
            return Double.compare(this.toDoubleOrError(a, x), this.toDoubleOrError(b, x));
        }
    }

    protected boolean eq(Object a, Object b) {
        boolean value = Objects.equals(a, b);
        if (!value && a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        return value;
    }

    private double toDoubleOrError(Object value, RuntimeException x) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw x;
    }
}

