/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time.internal.token;

import java.text.ParsePosition;
import wiremock.com.ethlo.time.internal.util.ErrorUtil;
import wiremock.com.ethlo.time.token.DateTimeToken;

public class SeparatorToken
implements DateTimeToken {
    private final char separator;

    public SeparatorToken(char separator) {
        this.separator = separator;
    }

    @Override
    public int read(String text, ParsePosition parsePosition) {
        int index = parsePosition.getIndex();
        if (text.length() > index && text.charAt(index) == this.separator) {
            parsePosition.setIndex(index + 1);
        } else if (text.length() <= index) {
            ErrorUtil.raiseUnexpectedEndOfText(text, text.length());
        } else if (text.charAt(index) != this.separator) {
            ErrorUtil.raiseUnexpectedCharacter(text, index, this.separator);
        }
        parsePosition.setIndex(index + 1);
        return 1;
    }

    public String toString() {
        return "separator: " + this.separator;
    }
}

