/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.w3c.dom.Node;
import wiremock.org.hamcrest.Matcher;

public class XpathRequestMatchers {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final XpathExpectationsHelper xpathHelper;

    protected XpathRequestMatchers(String expression, @Nullable Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public RequestMatcher node(Matcher<? super Node> matcher) {
        return request2 -> this.xpathHelper.assertNode(request2.getBodyAsBytes(), DEFAULT_ENCODING, matcher);
    }

    public RequestMatcher exists() {
        return request2 -> this.xpathHelper.exists(request2.getBodyAsBytes(), DEFAULT_ENCODING);
    }

    public RequestMatcher doesNotExist() {
        return request2 -> this.xpathHelper.doesNotExist(request2.getBodyAsBytes(), DEFAULT_ENCODING);
    }

    public RequestMatcher nodeCount(Matcher<? super Integer> matcher) {
        return request2 -> this.xpathHelper.assertNodeCount(request2.getBodyAsBytes(), DEFAULT_ENCODING, matcher);
    }

    public RequestMatcher nodeCount(int expectedCount) {
        return request2 -> this.xpathHelper.assertNodeCount(request2.getBodyAsBytes(), DEFAULT_ENCODING, expectedCount);
    }

    public RequestMatcher string(Matcher<? super String> matcher) {
        return request2 -> this.xpathHelper.assertString(request2.getBodyAsBytes(), DEFAULT_ENCODING, matcher);
    }

    public RequestMatcher string(String content) {
        return request2 -> this.xpathHelper.assertString(request2.getBodyAsBytes(), DEFAULT_ENCODING, content);
    }

    public RequestMatcher number(Matcher<? super Double> matcher) {
        return request2 -> this.xpathHelper.assertNumber(request2.getBodyAsBytes(), DEFAULT_ENCODING, matcher);
    }

    public RequestMatcher number(Double value) {
        return request2 -> this.xpathHelper.assertNumber(request2.getBodyAsBytes(), DEFAULT_ENCODING, value);
    }

    public RequestMatcher booleanValue(Boolean value) {
        return request2 -> this.xpathHelper.assertBoolean(request2.getBodyAsBytes(), DEFAULT_ENCODING, value);
    }

    @FunctionalInterface
    private static interface XpathRequestMatcher
    extends RequestMatcher {
        @Override
        default public void match(ClientHttpRequest request2) {
            try {
                this.matchInternal((MockClientHttpRequest)request2);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse XML request content", ex);
            }
        }

        public void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

