/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import java.util.Collections;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;

final class AotMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 1963364911008547843L;
    private final Class<? extends ApplicationContextInitializer<?>> contextInitializerClass;
    private final MergedContextConfiguration original;

    AotMergedContextConfiguration(Class<?> testClass, Class<? extends ApplicationContextInitializer<?>> contextInitializerClass, MergedContextConfiguration original, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        super(testClass, null, null, Collections.singleton(contextInitializerClass), null, original.getContextLoader(), cacheAwareContextLoaderDelegate, original.getParent());
        this.contextInitializerClass = contextInitializerClass;
        this.original = original;
    }

    MergedContextConfiguration getOriginal() {
        return this.original;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AotMergedContextConfiguration)) return false;
        AotMergedContextConfiguration that = (AotMergedContextConfiguration)other;
        if (!this.contextInitializerClass.equals(that.contextInitializerClass)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.contextInitializerClass.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this, new DefaultToStringStyler(new SimpleValueStyler())).append("testClass", this.getTestClass()).append("contextInitializerClass", this.contextInitializerClass).append("original", this.original).toString();
    }
}

