/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class MockServerHttpResponse
extends AbstractServerHttpResponse {
    private Flux<DataBuffer> body = Flux.error((Throwable)new IllegalStateException("No content was written nor was setComplete() called on this response."));
    private Function<Flux<DataBuffer>, Mono<Void>> writeHandler = body2 -> {
        Sinks.Empty completion = Sinks.unsafe().empty();
        this.body = body2.cache();
        this.body.subscribe(aVoid -> {}, arg_0 -> ((Sinks.Empty)completion).tryEmitError(arg_0), () -> ((Sinks.Empty)completion).tryEmitEmpty());
        return completion.asMono();
    };

    public MockServerHttpResponse() {
        this(DefaultDataBufferFactory.sharedInstance);
    }

    public MockServerHttpResponse(DataBufferFactory dataBufferFactory) {
        super(dataBufferFactory);
    }

    public void setWriteHandler(Function<Flux<DataBuffer>, Mono<Void>> writeHandler) {
        Assert.notNull(writeHandler, "'writeHandler' is required");
        this.body = Flux.error((Throwable)new IllegalStateException("Not available with custom write handler."));
        this.writeHandler = writeHandler;
    }

    public <T> T getNativeResponse() {
        throw new IllegalStateException("This is a mock. No running server, no native response.");
    }

    protected void applyStatusCode() {
    }

    protected void applyHeaders() {
    }

    protected void applyCookies() {
        for (List cookies : this.getCookies().values()) {
            for (ResponseCookie cookie : cookies) {
                this.getHeaders().add("Set-Cookie", cookie.toString());
            }
        }
    }

    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body2) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body2));
    }

    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body2).concatMap(Flux::from));
    }

    public Mono<Void> setComplete() {
        return this.doCommit(() -> Mono.defer(() -> this.writeHandler.apply((Flux<DataBuffer>)Flux.empty())));
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = Optional.ofNullable(this.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
        return DataBufferUtils.join(this.getBody()).map(buffer -> {
            String s2 = buffer.toString(charset);
            DataBufferUtils.release(buffer);
            return s2;
        }).defaultIfEmpty((Object)"");
    }
}

