/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

@FunctionalInterface
public interface AotApplicationContextInitializer<C extends ConfigurableApplicationContext>
extends ApplicationContextInitializer<C> {
    public static <C extends ConfigurableApplicationContext> AotApplicationContextInitializer<C> forInitializerClasses(String ... initializerClassNames) {
        Assert.noNullElements((Object[])initializerClassNames, "'initializerClassNames' must not contain null elements");
        return applicationContext -> AotApplicationContextInitializer.initialize(applicationContext, initializerClassNames);
    }

    private static <C extends ConfigurableApplicationContext> void initialize(C applicationContext, String ... initializerClassNames) {
        Log logger = LogFactory.getLog(AotApplicationContextInitializer.class);
        ClassLoader classLoader = applicationContext.getClassLoader();
        logger.debug("Initializing ApplicationContext with AOT");
        for (String initializerClassName : initializerClassNames) {
            logger.trace(LogMessage.format("Applying %s", (Object)initializerClassName));
            AotApplicationContextInitializer.instantiateInitializer(initializerClassName, classLoader).initialize(applicationContext);
        }
    }

    public static <C extends ConfigurableApplicationContext> ApplicationContextInitializer<C> instantiateInitializer(String initializerClassName, @Nullable ClassLoader classLoader) {
        try {
            Class<?> initializerClass = ClassUtils.resolveClassName(initializerClassName, classLoader);
            Assert.isAssignable(ApplicationContextInitializer.class, initializerClass);
            return (ApplicationContextInitializer)BeanUtils.instantiateClass(initializerClass);
        }
        catch (BeanInstantiationException ex) {
            throw new IllegalArgumentException("Failed to instantiate ApplicationContextInitializer: " + initializerClassName, ex);
        }
    }
}

