/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.web.embedded.undertow.HttpHandlerFactory;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.xnio.channels.BoundChannel;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

public class UndertowWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(UndertowWebServer.class);
    private final AtomicReference<GracefulShutdownCallback> gracefulShutdownCallback = new AtomicReference();
    private final Object monitor = new Object();
    private final Undertow.Builder builder;
    private final Iterable<HttpHandlerFactory> httpHandlerFactories;
    private final boolean autoStart;
    private Undertow undertow;
    private volatile boolean started = false;
    private volatile GracefulShutdownHandler gracefulShutdown;
    private volatile List<Closeable> closeables;

    public UndertowWebServer(Undertow.Builder builder, boolean autoStart) {
        this(builder, Collections.singleton(new CloseableHttpHandlerFactory(null)), autoStart);
    }

    public UndertowWebServer(Undertow.Builder builder, Iterable<HttpHandlerFactory> httpHandlerFactories, boolean autoStart) {
        this.builder = builder;
        this.httpHandlerFactories = httpHandlerFactories;
        this.autoStart = autoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                if (!this.autoStart) {
                    return;
                }
                if (this.undertow == null) {
                    this.undertow = this.createUndertowServer();
                }
                this.undertow.start();
                this.started = true;
                String message = this.getStartLogMessage();
                logger.info(message);
            }
            catch (Exception ex) {
                try {
                    PortInUseException.ifPortBindingException(ex, bindException -> {
                        List<Port> failedPorts = this.getConfiguredPorts();
                        failedPorts.removeAll(this.getActualPorts());
                        if (failedPorts.size() == 1) {
                            throw new PortInUseException(failedPorts.get(0).getNumber());
                        }
                    });
                    throw new WebServerException("Unable to start embedded Undertow", ex);
                }
                catch (Throwable throwable) {
                    this.destroySilently();
                    throw throwable;
                }
            }
        }
    }

    private void destroySilently() {
        try {
            if (this.undertow != null) {
                this.undertow.stop();
                this.closeables.forEach(this::closeSilently);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSilently(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Undertow createUndertowServer() {
        this.closeables = new ArrayList<Closeable>();
        this.gracefulShutdown = null;
        HttpHandler handler = this.createHttpHandler();
        this.builder.setHandler(handler);
        return this.builder.build();
    }

    protected HttpHandler createHttpHandler() {
        HttpHandler handler = null;
        for (HttpHandlerFactory factory : this.httpHandlerFactories) {
            handler = factory.getHandler(handler);
            if (handler instanceof Closeable) {
                Closeable closeable = (Closeable)handler;
                this.closeables.add(closeable);
            }
            if (!(handler instanceof GracefulShutdownHandler)) continue;
            GracefulShutdownHandler shutdownHandler = (GracefulShutdownHandler)handler;
            Assert.isNull((Object)this.gracefulShutdown, "Only a single GracefulShutdownHandler can be defined");
            this.gracefulShutdown = shutdownHandler;
        }
        return handler;
    }

    private String getPortsDescription() {
        StringBuilder description = new StringBuilder();
        List<Port> ports = this.getActualPorts();
        description.append("port");
        if (ports.size() != 1) {
            description.append("s");
        }
        description.append(" ");
        if (!ports.isEmpty()) {
            description.append(StringUtils.collectionToDelimitedString(ports, ", "));
        } else {
            description.append("unknown");
        }
        return description.toString();
    }

    private List<Port> getActualPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                for (BoundChannel channel : this.extractChannels()) {
                    ports.add(this.getPortFromChannel(channel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private List<BoundChannel> extractChannels() {
        Field channelsField = ReflectionUtils.findField(Undertow.class, "channels");
        ReflectionUtils.makeAccessible(channelsField);
        return (List)ReflectionUtils.getField(channelsField, this.undertow);
    }

    private Port getPortFromChannel(BoundChannel channel) {
        SocketAddress socketAddress = channel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            Field sslField = ReflectionUtils.findField(channel.getClass(), "ssl");
            String protocol = sslField != null ? "https" : "http";
            return new Port(inetSocketAddress.getPort(), protocol);
        }
        return null;
    }

    private List<Port> getConfiguredPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Object listener : this.extractListeners()) {
            try {
                Port port = this.getPortFromListener(listener);
                if (port.getNumber() == 0) continue;
                ports.add(port);
            }
            catch (Exception exception) {}
        }
        return ports;
    }

    private List<Object> extractListeners() {
        Field listenersField = ReflectionUtils.findField(Undertow.class, "listeners");
        ReflectionUtils.makeAccessible(listenersField);
        return (List)ReflectionUtils.getField(listenersField, this.undertow);
    }

    private Port getPortFromListener(Object listener) {
        Field typeField = ReflectionUtils.findField(listener.getClass(), "type");
        ReflectionUtils.makeAccessible(typeField);
        String protocol = ReflectionUtils.getField(typeField, listener).toString();
        Field portField = ReflectionUtils.findField(listener.getClass(), "port");
        ReflectionUtils.makeAccessible(portField);
        int port = (Integer)ReflectionUtils.getField(portField, listener);
        return new Port(port, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            if (this.gracefulShutdown != null) {
                this.notifyGracefulCallback(false);
            }
            try {
                this.undertow.stop();
                for (Closeable closeable : this.closeables) {
                    closeable.close();
                }
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop Undertow", ex);
            }
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getActualPorts();
        if (ports.isEmpty()) {
            return -1;
        }
        return ports.get(0).getNumber();
    }

    public Undertow getUndertow() {
        return this.undertow;
    }

    @Override
    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        logger.info("Commencing graceful shutdown. Waiting for active requests to complete");
        this.gracefulShutdownCallback.set(callback);
        this.gracefulShutdown.shutdown();
        this.gracefulShutdown.addShutdownListener(this::notifyGracefulCallback);
    }

    private void notifyGracefulCallback(boolean success) {
        GracefulShutdownCallback callback = this.gracefulShutdownCallback.getAndSet(null);
        if (callback != null) {
            if (success) {
                logger.info("Graceful shutdown complete");
                callback.shutdownComplete(GracefulShutdownResult.IDLE);
            } else {
                logger.info("Graceful shutdown aborted with one or more requests still active");
                callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
            }
        }
    }

    protected String getStartLogMessage() {
        return "Undertow started on " + this.getPortsDescription();
    }

    private static final class CloseableHttpHandlerFactory
    implements HttpHandlerFactory {
        private final Closeable closeable;

        private CloseableHttpHandlerFactory(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public HttpHandler getHandler(final HttpHandler next) {
            if (this.closeable == null) {
                return next;
            }
            return new CloseableHttpHandler(){

                public void handleRequest(HttpServerExchange exchange2) throws Exception {
                    next.handleRequest(exchange2);
                }

                @Override
                public void close() throws IOException {
                    closeable.close();
                }
            };
        }
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        int getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Port other = (Port)obj;
            return this.number == other.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }

    static class UndertowWebServerRuntimeHints
    implements RuntimeHintsRegistrar {
        UndertowWebServerRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerTypeIfPresent(classLoader, "io.undertow.Undertow", hint -> hint.withField("listeners").withField("channels"));
            hints.reflection().registerTypeIfPresent(classLoader, "io.undertow.Undertow$ListenerConfig", hint -> hint.withField("type").withField("port"));
            hints.reflection().registerTypeIfPresent(classLoader, "io.undertow.protocols.ssl.UndertowAcceptingSslChannel", hint -> hint.withField("ssl"));
        }
    }

    private static interface CloseableHttpHandler
    extends HttpHandler,
    Closeable {
    }
}

