/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.ForwardHeadersCustomizer;
import org.springframework.boot.web.embedded.jetty.JasperInitializer;
import org.springframework.boot.web.embedded.jetty.JettyEmbeddedErrorHandler;
import org.springframework.boot.web.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyHandlerWrappers;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.embedded.jetty.LoaderHidingResource;
import org.springframework.boot.web.embedded.jetty.ServletContextInitializerConfiguration;
import org.springframework.boot.web.embedded.jetty.SslServerCustomizer;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.CookieSameSiteSupplier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import wiremock.jakarta.servlet.http.Cookie;
import wiremock.org.eclipse.jetty.ee10.servlet.ErrorHandler;
import wiremock.org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import wiremock.org.eclipse.jetty.ee10.servlet.ListenerHolder;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletHandler;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletMapping;
import wiremock.org.eclipse.jetty.ee10.servlet.SessionHandler;
import wiremock.org.eclipse.jetty.ee10.servlet.Source;
import wiremock.org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import wiremock.org.eclipse.jetty.ee10.webapp.Configuration;
import wiremock.org.eclipse.jetty.ee10.webapp.WebAppContext;
import wiremock.org.eclipse.jetty.ee10.webapp.WebInfConfiguration;
import wiremock.org.eclipse.jetty.http.CookieCompliance;
import wiremock.org.eclipse.jetty.http.HttpCookie;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.http.SetCookieParser;
import wiremock.org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import wiremock.org.eclipse.jetty.server.AbstractConnectionFactory;
import wiremock.org.eclipse.jetty.server.AbstractConnector;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.ConnectionLimit;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.HttpCookieUtils;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.handler.StatisticsHandler;
import wiremock.org.eclipse.jetty.session.DefaultSessionCache;
import wiremock.org.eclipse.jetty.session.FileSessionDataStore;
import wiremock.org.eclipse.jetty.session.SessionCache;
import wiremock.org.eclipse.jetty.session.SessionDataStore;
import wiremock.org.eclipse.jetty.session.SessionManager;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.util.resource.ResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.URLResourceFactory;
import wiremock.org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableJettyWebServerFactory,
ResourceLoaderAware {
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private boolean useForwardHeaders;
    private int acceptors = -1;
    private int selectors = -1;
    private Set<JettyServerCustomizer> jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>();
    private ResourceLoader resourceLoader;
    private ThreadPool threadPool;
    private int maxConnections = -1;

    public JettyServletWebServerFactory() {
    }

    public JettyServletWebServerFactory(int port) {
        super(port);
    }

    public JettyServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        JettyEmbeddedWebAppContext context = new JettyEmbeddedWebAppContext();
        context.getContext().getServletContext().setExtendedListenerTypes(true);
        int port = Math.max(this.getPort(), 0);
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = this.createServer(address);
        context.setServer(server);
        this.configureWebAppContext(context, initializers);
        server.setHandler(this.addHandlerWrappers((Handler)((Object)context)));
        this.logger.info("Server initialized with port: " + port);
        if (this.maxConnections > -1) {
            server.addBean(new ConnectionLimit(this.maxConnections, server.getConnectors()));
        }
        if (Ssl.isEnabled(this.getSsl())) {
            this.customizeSsl(server, address);
        }
        for (JettyServerCustomizer customizer2 : this.getServerCustomizers()) {
            customizer2.customize(server);
        }
        if (this.useForwardHeaders) {
            new ForwardHeadersCustomizer().customize(server);
        }
        if (this.getShutdown() == Shutdown.GRACEFUL) {
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler(server.getHandler());
            server.setHandler(statisticsHandler);
        }
        return this.getJettyWebServer(server);
    }

    private Server createServer(InetSocketAddress address) {
        Server server = new Server(this.getThreadPool());
        server.setConnectors(new Connector[]{this.createConnector(address, server)});
        server.setStopTimeout(0L);
        MimeTypes.Mutable mimeTypes = server.getMimeTypes();
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        return server;
    }

    private AbstractConnector createConnector(InetSocketAddress address, Server server) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        ArrayList<AbstractConnectionFactory> connectionFactories = new ArrayList<AbstractConnectionFactory>();
        connectionFactories.add(new HttpConnectionFactory(httpConfiguration));
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connectionFactories.add(new HTTP2CServerConnectionFactory(httpConfiguration));
        }
        ServerConnector connector = new ServerConnector(server, this.acceptors, this.selectors, connectionFactories.toArray(new ConnectionFactory[0]));
        connector.setHost(address.getHostString());
        connector.setPort(address.getPort());
        return connector;
    }

    private Handler addHandlerWrappers(Handler handler) {
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createGzipHandlerWrapper(this.getCompression()));
        }
        if (StringUtils.hasText(this.getServerHeader())) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createServerHeaderHandlerWrapper(this.getServerHeader()));
        }
        if (!CollectionUtils.isEmpty(this.getCookieSameSiteSuppliers())) {
            handler = this.applyWrapper(handler, new SuppliedSameSiteCookieHandlerWrapper(this.getSessionCookieName(), this.getCookieSameSiteSuppliers()));
        }
        return handler;
    }

    private String getSessionCookieName() {
        String name = this.getSession().getCookie().getName();
        return name != null ? name : "JSESSIONID";
    }

    private Handler applyWrapper(Handler handler, Handler.Wrapper wrapper) {
        wrapper.setHandler(handler);
        return wrapper;
    }

    private void customizeSsl(Server server, InetSocketAddress address) {
        Assert.state(this.getSsl().getServerNameBundles().isEmpty(), "Server name SSL bundles are not supported with Jetty");
        new SslServerCustomizer(this.getHttp2(), address, this.getSsl().getClientAuth(), this.getSslBundle()).customize(server);
    }

    protected final void configureWebAppContext(WebAppContext context, ServletContextInitializer ... initializers) {
        String contextPath;
        Assert.notNull((Object)context, "Context must not be null");
        context.clearAliasChecks();
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength(contextPath = this.getContextPath()) ? contextPath : "/");
        context.setDisplayName(this.getDisplayName());
        this.configureDocumentRoot(context);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            context.addBean((Object)new JasperInitializer(context), true);
        }
        this.addLocaleMappings(context);
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        context.setThrowUnavailableOnStartupException(true);
        this.configureSession(context);
        context.setTempDirectory(this.getTempDirectory(context));
        this.postProcessWebAppContext(context);
    }

    private void configureSession(WebAppContext context) {
        Duration sessionTimeout;
        SessionHandler handler = context.getSessionHandler();
        Cookie.SameSite sessionSameSite = this.getSession().getCookie().getSameSite();
        if (sessionSameSite != null) {
            handler.setSameSite(HttpCookie.SameSite.valueOf(sessionSameSite.name()));
        }
        handler.setMaxInactiveInterval(this.isNegative(sessionTimeout = this.getSession().getTimeout()) ? -1 : (int)sessionTimeout.getSeconds());
        if (this.getSession().isPersistent()) {
            DefaultSessionCache cache = new DefaultSessionCache((SessionManager)handler);
            FileSessionDataStore store = new FileSessionDataStore();
            store.setStoreDir(this.getValidSessionStoreDir());
            cache.setSessionDataStore((SessionDataStore)store);
            handler.setSessionCache((SessionCache)cache);
        }
    }

    private boolean isNegative(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative();
    }

    private void addLocaleMappings(WebAppContext context) {
        this.getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncoding(locale.toString(), charset.toString()));
    }

    private File getTempDirectory(WebAppContext context) {
        String temp = System.getProperty("java.io.tmpdir");
        return temp != null ? new File(temp, this.getTempDirectoryPrefix(context) + UUID.randomUUID()) : null;
    }

    private String getTempDirectoryPrefix(WebAppContext context) {
        try {
            return ((JettyEmbeddedWebAppContext)context).getCanonicalNameForTmpDir();
        }
        catch (Throwable ex) {
            return WebInfConfiguration.getCanonicalNameForWebAppTmpDir((WebAppContext)context);
        }
    }

    private void configureDocumentRoot(WebAppContext handler) {
        File root = this.getValidDocumentRoot();
        File docBase = root != null ? root : this.createTempDir("jetty-docbase");
        try {
            ResourceFactory resourceFactory = handler.getResourceFactory();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Resource rootResource = docBase.isDirectory() ? resourceFactory.newResource(docBase.getCanonicalFile().toURI()) : resourceFactory.newJarFileResource(docBase.toURI());
            resources.add(root != null ? new LoaderHidingResource(rootResource, rootResource) : rootResource);
            URLResourceFactory urlResourceFactory = new URLResourceFactory();
            for (URL resourceJarUrl : this.getUrlsOfJarsWithMetaInfResources()) {
                Resource resource = this.createResource(resourceJarUrl, resourceFactory, urlResourceFactory);
                if (resource == null) continue;
                resources.add(resource);
            }
            handler.setBaseResource(ResourceFactory.combine(resources));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource createResource(URL url, ResourceFactory resourceFactory, URLResourceFactory urlResourceFactory) throws Exception {
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.toURI());
            if (file.isFile()) {
                return resourceFactory.newResource("jar:" + url + "!/META-INF/resources/");
            }
            if (file.isDirectory()) {
                return resourceFactory.newResource(url).resolve("META-INF/resources/");
            }
        }
        return urlResourceFactory.newResource(url + "META-INF/resources/");
    }

    protected final void addDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("wiremock.org.eclipse.jetty.ee10.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        ServletMapping servletMapping = context.getServletHandler().getServletMapping("/");
        servletMapping.setFromDefaultDescriptor(true);
    }

    protected final void addJspServlet(WebAppContext context) {
        Assert.notNull((Object)context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.getJsp().getClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitParameters(this.getJsp().getInitParameters());
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Object> configurations = new ArrayList<Object>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        configurations.add((Object)new WebListenersConfiguration(this.getWebListenerClassNames()));
        configurations.addAll(this.getConfigurations());
        return configurations.toArray(new Configuration[0]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                context.setErrorHandler((Request.Handler)errorHandler);
                JettyServletWebServerFactory.this.addJettyErrorPages((ErrorHandler)errorHandler, JettyServletWebServerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes.Wrapper mimeTypes = (MimeTypes.Wrapper)context.getMimeTypes();
                mimeTypes.setWrapped(new MimeTypes(null));
                for (MimeMappings.Mapping mapping : JettyServletWebServerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        return new ServletContextInitializerConfiguration(initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyWebServer getJettyWebServer(Server server) {
        return new JettyWebServer(server, this.getPort() >= 0);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    @Override
    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    @Override
    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setServerCustomizers(Collection<? extends JettyServerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>(customizers);
    }

    public Collection<JettyServerCustomizer> getServerCustomizers() {
        return this.jettyServerCustomizers;
    }

    @Override
    public void addServerCustomizers(JettyServerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        this.jettyServerCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, "Configurations must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull((Object)configurations, "Configurations must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("wiremock.org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }

    private static class SuppliedSameSiteCookieHandlerWrapper
    extends Handler.Wrapper {
        private static final SetCookieParser setCookieParser = SetCookieParser.newInstance();
        private final String sessionCookieName;
        private final List<CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieHandlerWrapper(String sessionCookieName, List<CookieSameSiteSupplier> suppliers) {
            this.sessionCookieName = sessionCookieName;
            this.suppliers = suppliers;
        }

        public boolean handle(Request request2, Response response, Callback callback) throws Exception {
            SuppliedSameSiteCookieResponse wrappedResponse = new SuppliedSameSiteCookieResponse(request2, response);
            return super.handle(request2, (Response)((Object)wrappedResponse), callback);
        }

        private class SuppliedSameSiteCookieResponse
        extends Response.Wrapper {
            private final HttpFields.Mutable wrappedHeaders;

            SuppliedSameSiteCookieResponse(Request request2, Response wrapped) {
                super(request2, wrapped);
                this.wrappedHeaders = new SuppliedSameSiteCookieHeaders(request2.getConnectionMetaData().getHttpConfiguration().getResponseCookieCompliance(), wrapped.getHeaders());
            }

            public HttpFields.Mutable getHeaders() {
                return this.wrappedHeaders;
            }
        }

        private class SuppliedSameSiteCookieHeaders
        extends HttpFields.Mutable.Wrapper {
            private final CookieCompliance compliance;

            SuppliedSameSiteCookieHeaders(CookieCompliance compliance, HttpFields.Mutable fields) {
                super(fields);
                this.compliance = compliance;
            }

            public HttpField onAddField(HttpField field) {
                return field.getHeader() != HttpHeader.SET_COOKIE ? field : this.onAddSetCookieField(field);
            }

            private HttpField onAddSetCookieField(HttpField field) {
                HttpCookie cookie = setCookieParser.parse(field.getValue());
                if (cookie == null || this.isSessionCookie(cookie)) {
                    return field;
                }
                Cookie.SameSite sameSite = this.getSameSite(cookie);
                if (sameSite == null) {
                    return field;
                }
                HttpCookie updatedCookie = this.buildCookieWithUpdatedSameSite(cookie, sameSite);
                return new HttpCookieUtils.SetCookieHttpField(updatedCookie, this.compliance);
            }

            private boolean isSessionCookie(HttpCookie cookie) {
                return SuppliedSameSiteCookieHandlerWrapper.this.sessionCookieName.equals(cookie.getName());
            }

            private HttpCookie buildCookieWithUpdatedSameSite(HttpCookie cookie, Cookie.SameSite sameSite) {
                return HttpCookie.build((HttpCookie)cookie).sameSite(HttpCookie.SameSite.from((String)sameSite.name())).build();
            }

            private Cookie.SameSite getSameSite(HttpCookie cookie) {
                return this.getSameSite(this.asServletCookie(cookie));
            }

            private Cookie.SameSite getSameSite(Cookie cookie) {
                return SuppliedSameSiteCookieHandlerWrapper.this.suppliers.stream().map(supplier -> supplier.getSameSite(cookie)).filter(Objects::nonNull).findFirst().orElse(null);
            }

            private Cookie asServletCookie(HttpCookie cookie) {
                Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
                cookie.getAttributes().forEach((BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, setAttribute(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((Cookie)servletCookie));
                return servletCookie;
            }
        }
    }

    private static class WebListenersConfiguration
    extends AbstractConfiguration {
        private final Set<String> classNames;

        WebListenersConfiguration(Set<String> webListenerClassNames) {
            super(new AbstractConfiguration.Builder());
            this.classNames = webListenerClassNames;
        }

        public void configure(WebAppContext context) throws Exception {
            ServletHandler servletHandler = context.getServletHandler();
            for (String className : this.classNames) {
                this.configure(context, servletHandler, className);
            }
        }

        private void configure(WebAppContext context, ServletHandler servletHandler, String className) throws ClassNotFoundException {
            ListenerHolder holder = servletHandler.newListenerHolder(new Source(Source.Origin.ANNOTATION, className));
            holder.setHeldClass(this.loadClass(context, className));
            servletHandler.addListener(holder);
        }

        private Class<? extends EventListener> loadClass(WebAppContext context, String className) throws ClassNotFoundException {
            ClassLoader classLoader = context.getClassLoader();
            classLoader = classLoader != null ? classLoader : ((Object)((Object)this)).getClass().getClassLoader();
            return classLoader.loadClass(className);
        }
    }
}

