/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import org.springframework.boot.web.server.Compression;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipHandler;
import wiremock.org.eclipse.jetty.util.Callback;

final class JettyHandlerWrappers {
    private JettyHandlerWrappers() {
    }

    static Handler.Wrapper createGzipHandlerWrapper(Compression compression) {
        GzipHandler handler = new GzipHandler();
        handler.setMinGzipSize((int)compression.getMinResponseSize().toBytes());
        handler.setIncludedMimeTypes(compression.getMimeTypes());
        for (HttpMethod httpMethod : HttpMethod.values()) {
            handler.addIncludedMethods(httpMethod.name());
        }
        return handler;
    }

    static Handler.Wrapper createServerHeaderHandlerWrapper(String header) {
        return new ServerHeaderHandler(header);
    }

    private static class ServerHeaderHandler
    extends Handler.Wrapper {
        private static final String SERVER_HEADER = "server";
        private final String value;

        ServerHeaderHandler(String value) {
            this.value = value;
        }

        public boolean handle(Request request2, Response response, Callback callback) throws Exception {
            HttpFields.Mutable headers = response.getHeaders();
            if (!headers.contains(SERVER_HEADER)) {
                headers.add(SERVER_HEADER, this.value);
            }
            return super.handle(request2, response, callback);
        }
    }
}

